/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.gen.asm;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.classdump.luna.compiler.gen.CodeSegmenter;
import org.classdump.luna.compiler.gen.SegmentedCode;
import org.classdump.luna.compiler.gen.asm.ASMBytecodeEmitter;
import org.classdump.luna.compiler.gen.asm.BytecodeEmitVisitor;
import org.classdump.luna.compiler.gen.asm.helpers.ASMUtils;
import org.classdump.luna.compiler.ir.BasicBlock;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.impl.DefaultSavedState;
import org.classdump.luna.runtime.ExecutionContext;
import org.classdump.luna.runtime.ResolvedControlThrowable;
import org.classdump.luna.runtime.Resumable;
import org.classdump.luna.runtime.UnresolvedControlThrowable;
import org.classdump.luna.shaded.org.objectweb.asm.Opcodes;
import org.classdump.luna.shaded.org.objectweb.asm.Type;
import org.classdump.luna.shaded.org.objectweb.asm.tree.AbstractInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.FieldInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.FieldNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.FrameNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InsnList;
import org.classdump.luna.shaded.org.objectweb.asm.tree.InsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.JumpInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LabelNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.LocalVariableNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.MethodInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.MethodNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.TryCatchBlockNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.TypeInsnNode;
import org.classdump.luna.shaded.org.objectweb.asm.tree.VarInsnNode;

class RunMethod {
    public final int LV_CONTEXT = 1;
    public final int LV_RESUME = 2;
    public final int LV_VARARGS = 3;
    public static final int ST_SHIFT_SEGMENT = 24;
    public static final int ST_SHIFT_LABELIDX = 16;
    private final ASMBytecodeEmitter context;
    private final List<MethodNode> methodNodes;
    private final boolean resumable;
    private final List<ClosureFieldInstance> closureFields;
    private final List<ConstFieldInstance> constFields;

    static int labelStateIdx(SegmentedCode.LabelEntry le) {
        return le.segmentIdx << 24 | le.idx << 16;
    }

    public RunMethod(ASMBytecodeEmitter context) {
        this.context = Objects.requireNonNull(context);
        final SegmentedCode segmentedCode = CodeSegmenter.segment(context.fn.code(), context.compilerSettings.nodeSizeLimit());
        this.methodNodes = new ArrayList<MethodNode>();
        this.closureFields = new ArrayList<ClosureFieldInstance>();
        this.constFields = new ArrayList<ConstFieldInstance>();
        if (segmentedCode.isSingleton()) {
            BytecodeEmitVisitor visitor = new BytecodeEmitVisitor(context, this, context.slots, context.types, this.closureFields, this.constFields, -1, new LabelResolver(){

                @Override
                public boolean isLocalLabel(Label l) {
                    return true;
                }

                @Override
                public int labelStateIndex(Label l) {
                    throw new IllegalStateException();
                }
            });
            this.methodNodes.add(this.emitSingletonRunMethod(visitor, segmentedCode.segments().get(0)));
            this.resumable = visitor.isResumable();
        } else {
            boolean resumable = false;
            for (int i = 0; i < segmentedCode.segments().size(); ++i) {
                final int thisSegmentIdx = i;
                BytecodeEmitVisitor visitor = new BytecodeEmitVisitor(context, this, context.slots, context.types, this.closureFields, this.constFields, i, new LabelResolver(){

                    @Override
                    public boolean isLocalLabel(Label l) {
                        return segmentedCode.labelEntry((Label)l).segmentIdx == thisSegmentIdx;
                    }

                    @Override
                    public int labelStateIndex(Label l) {
                        return RunMethod.labelStateIdx(segmentedCode.labelEntry(l));
                    }
                });
                this.methodNodes.add(this.emitSegmentedSubRunMethod(i, visitor, segmentedCode.segments().get(i)));
                resumable |= visitor.isResumable();
            }
            this.resumable = resumable;
            this.methodNodes.add(this.emitSegmentedRunMethod(segmentedCode.segments().size()));
        }
    }

    public int numOfRegisters() {
        return this.context.slots.numSlots();
    }

    public int slotOffset() {
        return this.context.isVararg() ? 4 : 3;
    }

    public boolean isResumable() {
        return this.resumable;
    }

    public String[] throwsExceptions() {
        return new String[]{Type.getInternalName(ResolvedControlThrowable.class)};
    }

    public boolean usesSnapshotMethod() {
        return this.isResumable();
    }

    private String snapshotMethodName() {
        return "snapshot";
    }

    private Type snapshotMethodType() {
        ArrayList<Type> args = new ArrayList<Type>();
        args.add(Type.INT_TYPE);
        if (this.context.isVararg()) {
            args.add(ASMUtils.arrayTypeFor(Object.class));
        }
        for (int i = 0; i < this.numOfRegisters(); ++i) {
            args.add(Type.getType(Object.class));
        }
        return Type.getMethodType(this.context.savedStateClassType(), args.toArray(new Type[0]));
    }

    public MethodInsnNode snapshotMethodInvokeInsn() {
        return new MethodInsnNode(183, this.context.thisClassType().getInternalName(), this.snapshotMethodName(), this.snapshotMethodType().getDescriptor(), false);
    }

    public MethodNode snapshotMethodNode() {
        MethodNode node = new MethodNode(2, this.snapshotMethodName(), this.snapshotMethodType().getDescriptor(), null, null);
        InsnList il = node.instructions;
        LabelNode begin = new LabelNode();
        LabelNode end = new LabelNode();
        il.add(begin);
        il.add(new TypeInsnNode(187, Type.getInternalName(DefaultSavedState.class)));
        il.add(new InsnNode(89));
        il.add(new VarInsnNode(21, 1));
        int numRegs = this.numOfRegisters() + (this.context.isVararg() ? 1 : 0);
        int regOffset = this.context.isVararg() ? 3 : 2;
        il.add(ASMUtils.loadInt(numRegs));
        il.add(new TypeInsnNode(189, Type.getInternalName(Object.class)));
        for (int i = 0; i < numRegs; ++i) {
            il.add(new InsnNode(89));
            il.add(ASMUtils.loadInt(i));
            il.add(new VarInsnNode(25, 2 + i));
            il.add(new InsnNode(83));
        }
        il.add(ASMUtils.ctor(Type.getType(DefaultSavedState.class), Type.INT_TYPE, ASMUtils.arrayTypeFor(Object.class)));
        il.add(new InsnNode(176));
        il.add(end);
        List locals = node.localVariables;
        locals.add(new LocalVariableNode("this", this.context.thisClassType().getDescriptor(), null, begin, end, 0));
        locals.add(new LocalVariableNode("rp", Type.INT_TYPE.getDescriptor(), null, begin, end, 1));
        if (this.context.isVararg()) {
            locals.add(new LocalVariableNode("varargs", ASMUtils.arrayTypeFor(Object.class).getDescriptor(), null, begin, end, 2));
        }
        for (int i = 0; i < this.numOfRegisters(); ++i) {
            locals.add(new LocalVariableNode("r_" + i, Type.getDescriptor(Object.class), null, begin, end, regOffset + i));
        }
        node.maxLocals = 2 + this.numOfRegisters();
        node.maxStack = 7;
        return node;
    }

    public String methodName() {
        return "run";
    }

    private Type methodType(Type returnType) {
        ArrayList<Type> args = new ArrayList<Type>();
        args.add(Type.getType(ExecutionContext.class));
        args.add(Type.INT_TYPE);
        if (this.context.isVararg()) {
            args.add(ASMUtils.arrayTypeFor(Object.class));
        }
        for (int i = 0; i < this.numOfRegisters(); ++i) {
            args.add(Type.getType(Object.class));
        }
        return Type.getMethodType(returnType, args.toArray(new Type[0]));
    }

    public Type methodType() {
        return this.methodType(Type.VOID_TYPE);
    }

    private Type subMethodType() {
        return this.methodType(this.context.savedStateClassType());
    }

    public AbstractInsnNode methodInvokeInsn() {
        return new MethodInsnNode(183, this.context.thisClassType().getInternalName(), this.methodName(), this.methodType().getDescriptor(), false);
    }

    private InsnList errorState(LabelNode label) {
        InsnList il = new InsnList();
        il.add(label);
        il.add(ASMUtils.frameSame());
        il.add(new TypeInsnNode(187, Type.getInternalName(IllegalStateException.class)));
        il.add(new InsnNode(89));
        il.add(ASMUtils.ctor(IllegalStateException.class, new Class[0]));
        il.add(new InsnNode(191));
        return il;
    }

    private InsnList dispatchTable(List<LabelNode> extLabels, List<LabelNode> resumptionLabels, LabelNode errorStateLabel) {
        InsnList il = new InsnList();
        assert (!extLabels.isEmpty());
        ArrayList<LabelNode> labels = new ArrayList<LabelNode>();
        labels.addAll(extLabels);
        labels.addAll(resumptionLabels);
        LabelNode[] labelArray = labels.toArray(new LabelNode[labels.size()]);
        int min = 1 - extLabels.size();
        int max = resumptionLabels.size();
        il.add(new VarInsnNode(21, 2));
        il.add(new TableSwitchInsnNode(min, max, errorStateLabel, labelArray));
        return il;
    }

    InsnList createSnapshot() {
        InsnList il = new InsnList();
        il.add(new VarInsnNode(25, 0));
        il.add(new VarInsnNode(25, 0));
        il.add(new VarInsnNode(21, 2));
        if (this.context.isVararg()) {
            il.add(new VarInsnNode(25, 3));
        }
        for (int i = 0; i < this.numOfRegisters(); ++i) {
            il.add(new VarInsnNode(25, this.slotOffset() + i));
        }
        il.add(this.snapshotMethodInvokeInsn());
        return il;
    }

    protected InsnList resumptionHandler(LabelNode label) {
        InsnList il = new InsnList();
        il.add(label);
        il.add(ASMUtils.frameSame1(UnresolvedControlThrowable.class));
        il.add(this.createSnapshot());
        il.add(new MethodInsnNode(182, Type.getInternalName(UnresolvedControlThrowable.class), "resolve", Type.getMethodType(Type.getType(ResolvedControlThrowable.class), Type.getType(Resumable.class), Type.getType(Object.class)).getDescriptor(), false));
        il.add(new InsnNode(191));
        return il;
    }

    public List<ClosureFieldInstance> closureFields() {
        return this.closureFields;
    }

    public List<ConstFieldInstance> constFields() {
        return this.constFields;
    }

    private List<LocalVariableNode> baseLocals(LabelNode l_begin, LabelNode l_end) {
        ArrayList<LocalVariableNode> locals = new ArrayList<LocalVariableNode>();
        locals.add(new LocalVariableNode("this", this.context.thisClassType().getDescriptor(), null, l_begin, l_end, 0));
        locals.add(new LocalVariableNode("context", Type.getDescriptor(ExecutionContext.class), null, l_begin, l_end, 1));
        locals.add(new LocalVariableNode("rp", Type.INT_TYPE.getDescriptor(), null, l_begin, l_end, 2));
        if (this.context.isVararg()) {
            locals.add(new LocalVariableNode("varargs", ASMUtils.arrayTypeFor(Object.class).getDescriptor(), null, l_begin, l_end, 3));
        }
        for (int i = 0; i < this.numOfRegisters(); ++i) {
            locals.add(new LocalVariableNode("s_" + i, Type.getDescriptor(Object.class), null, l_begin, l_end, this.slotOffset() + i));
        }
        return locals;
    }

    private void addLocals(MethodNode node, LabelNode l_begin, LabelNode l_end, BytecodeEmitVisitor visitor) {
        List locals = node.localVariables;
        locals.addAll(this.baseLocals(l_begin, l_end));
        locals.addAll(visitor.locals());
    }

    private MethodNode emitRunMethod(String methodName, Type returnType, BytecodeEmitVisitor visitor, List<BasicBlock> blocks, boolean sub) {
        LabelNode l_head;
        MethodNode node = new MethodNode(2, methodName, this.methodType(returnType).getDescriptor(), null, this.throwsExceptions());
        InsnList insns = node.instructions;
        LabelNode l_begin = new LabelNode();
        LabelNode l_end = new LabelNode();
        visitor.visitBlocks(blocks);
        InsnList prefix = new InsnList();
        InsnList suffix = new InsnList();
        ArrayList<LabelNode> els = new ArrayList<LabelNode>();
        if (sub) {
            assert (!blocks.isEmpty());
            for (int i = blocks.size() - 1; i >= 0; --i) {
                BasicBlock blk = blocks.get(i);
                LabelNode l = visitor.labels.get(blk.label());
                assert (l != null);
                els.add(l);
            }
            l_head = visitor.labels.get(blocks.get(0).label());
        } else {
            l_head = new LabelNode();
            els.add(l_head);
        }
        assert (l_head != null);
        if (visitor.isResumable()) {
            LabelNode l_error_state = new LabelNode();
            LabelNode l_handler_begin = new LabelNode();
            List<LabelNode> rls = visitor.resumptionLabels();
            assert (!rls.isEmpty() || !els.isEmpty());
            prefix.add(this.dispatchTable(els, rls, l_error_state));
            LabelNode l_entry = l_head;
            if (!sub) {
                prefix.add(l_entry);
                prefix.add(ASMUtils.frameSame());
            }
            suffix.add(this.errorState(l_error_state));
            suffix.add(this.resumptionHandler(l_handler_begin));
            node.tryCatchBlocks.add(new TryCatchBlockNode(l_entry, l_error_state, l_handler_begin, Type.getInternalName(UnresolvedControlThrowable.class)));
        }
        insns.add(l_begin);
        insns.add(prefix);
        insns.add(visitor.instructions());
        insns.add(suffix);
        insns.add(l_end);
        this.addLocals(node, l_begin, l_end, visitor);
        return node;
    }

    private MethodNode emitSingletonRunMethod(BytecodeEmitVisitor visitor, List<BasicBlock> blocks) {
        return this.emitRunMethod(this.methodName(), Type.VOID_TYPE, visitor, blocks, false);
    }

    private String subRunMethodName(int segmentIdx) {
        return "run_" + segmentIdx;
    }

    private MethodNode emitSegmentedSubRunMethod(int segmentIdx, BytecodeEmitVisitor visitor, List<BasicBlock> blocks) {
        return this.emitRunMethod(this.subRunMethodName(segmentIdx), this.context.savedStateClassType(), visitor, blocks, true);
    }

    private MethodNode emitSegmentedRunMethod(int numOfSegments) {
        int i;
        MethodNode node = new MethodNode(2, this.methodName(), this.methodType().getDescriptor(), null, this.throwsExceptions());
        InsnList il = node.instructions;
        int lvOffset = this.slotOffset() + this.numOfRegisters();
        int lv_rpp = lvOffset + 0;
        int lv_methodIdx = lvOffset + 1;
        int lv_jmpIdx = lvOffset + 2;
        int lv_stateIdx = lvOffset + 3;
        int lv_savedState = lvOffset + 4;
        LabelNode l_top = new LabelNode();
        LabelNode l_ret = new LabelNode();
        LabelNode l_end = new LabelNode();
        LabelNode l_rpp = new LabelNode();
        LabelNode l_methodIdx = new LabelNode();
        LabelNode l_jmpIdx = new LabelNode();
        LabelNode l_stateIdx = new LabelNode();
        LabelNode l_savedState = new LabelNode();
        il.add(l_top);
        il.add(new FrameNode(3, 0, null, 0, null));
        il.add(new VarInsnNode(21, 2));
        il.add(ASMUtils.loadInt(0xFFFFFF));
        il.add(new InsnNode(126));
        il.add(new VarInsnNode(54, lv_rpp));
        il.add(l_rpp);
        il.add(new FrameNode(1, 1, new Object[]{Opcodes.INTEGER}, 0, null));
        il.add(new VarInsnNode(21, 2));
        il.add(ASMUtils.loadInt(24));
        il.add(new InsnNode(124));
        il.add(new VarInsnNode(54, lv_methodIdx));
        il.add(l_methodIdx);
        il.add(new FrameNode(1, 1, new Object[]{Opcodes.INTEGER}, 0, null));
        il.add(new VarInsnNode(21, lv_rpp));
        il.add(ASMUtils.loadInt(16));
        il.add(new InsnNode(124));
        il.add(new VarInsnNode(54, lv_jmpIdx));
        il.add(l_jmpIdx);
        il.add(new FrameNode(1, 1, new Object[]{Opcodes.INTEGER}, 0, null));
        il.add(new VarInsnNode(21, 2));
        il.add(ASMUtils.loadInt(65535));
        il.add(new InsnNode(126));
        il.add(new VarInsnNode(21, lv_jmpIdx));
        il.add(new InsnNode(100));
        il.add(new VarInsnNode(54, lv_stateIdx));
        il.add(l_stateIdx);
        il.add(new FrameNode(1, 1, new Object[]{Opcodes.INTEGER}, 0, null));
        il.add(new InsnNode(1));
        il.add(new VarInsnNode(58, lv_savedState));
        il.add(l_savedState);
        il.add(new FrameNode(1, 1, new Object[]{this.context.savedStateClassType().getInternalName()}, 0, null));
        LabelNode l_after = new LabelNode();
        LabelNode l_error = new LabelNode();
        LabelNode[] l_invokes = new LabelNode[numOfSegments];
        for (i = 0; i < numOfSegments; ++i) {
            l_invokes[i] = new LabelNode();
        }
        il.add(new VarInsnNode(21, lv_methodIdx));
        il.add(new TableSwitchInsnNode(0, numOfSegments - 1, l_error, l_invokes));
        for (i = 0; i < numOfSegments; ++i) {
            il.add(l_invokes[i]);
            il.add(new FrameNode(3, 0, null, 0, null));
            il.add(new VarInsnNode(25, 0));
            il.add(new VarInsnNode(25, 1));
            il.add(new VarInsnNode(21, lv_stateIdx));
            if (this.context.isVararg()) {
                il.add(new VarInsnNode(25, 3));
            }
            for (int j = 0; j < this.numOfRegisters(); ++j) {
                il.add(new VarInsnNode(25, this.slotOffset() + j));
            }
            il.add(new MethodInsnNode(183, this.context.thisClassType().getInternalName(), this.subRunMethodName(i), this.subMethodType().getDescriptor(), false));
            il.add(new VarInsnNode(58, lv_savedState));
            il.add(new JumpInsnNode(167, l_after));
        }
        il.add(this.errorState(l_error));
        il.add(l_after);
        il.add(new FrameNode(3, 0, null, 0, null));
        il.add(new VarInsnNode(25, lv_savedState));
        il.add(new JumpInsnNode(198, l_ret));
        il.add(new VarInsnNode(25, lv_savedState));
        il.add(new MethodInsnNode(182, Type.getInternalName(DefaultSavedState.class), "resumptionPoint", Type.getMethodDescriptor(Type.INT_TYPE, new Type[0]), false));
        il.add(new VarInsnNode(54, 2));
        if (this.context.isVararg() || this.numOfRegisters() > 0) {
            il.add(new VarInsnNode(25, lv_savedState));
            il.add(new MethodInsnNode(182, Type.getInternalName(DefaultSavedState.class), "registers", Type.getMethodDescriptor(ASMUtils.arrayTypeFor(Object.class), new Type[0]), false));
            int numRegs = this.numOfRegisters() + (this.context.isVararg() ? 1 : 0);
            for (int i2 = 0; i2 < numRegs; ++i2) {
                if (i2 + 1 < numRegs) {
                    il.add(new InsnNode(89));
                }
                il.add(ASMUtils.loadInt(i2));
                il.add(new InsnNode(50));
                if (i2 == 0 && this.context.isVararg()) {
                    il.add(new TypeInsnNode(192, ASMUtils.arrayTypeFor(Object.class).getInternalName()));
                }
                il.add(new VarInsnNode(58, 3 + i2));
            }
        }
        il.add(new JumpInsnNode(167, l_top));
        il.add(l_ret);
        il.add(new FrameNode(3, 0, null, 0, null));
        il.add(new InsnNode(177));
        il.add(l_end);
        node.localVariables.addAll(this.baseLocals(l_top, l_end));
        node.localVariables.add(new LocalVariableNode("rpp", Type.INT_TYPE.getDescriptor(), null, l_rpp, l_ret, lv_rpp));
        node.localVariables.add(new LocalVariableNode("methodIdx", Type.INT_TYPE.getDescriptor(), null, l_methodIdx, l_ret, lv_methodIdx));
        node.localVariables.add(new LocalVariableNode("jmpIdx", Type.INT_TYPE.getDescriptor(), null, l_jmpIdx, l_ret, lv_jmpIdx));
        node.localVariables.add(new LocalVariableNode("stateIdx", Type.INT_TYPE.getDescriptor(), null, l_stateIdx, l_ret, lv_stateIdx));
        node.localVariables.add(new LocalVariableNode("savedState", this.context.savedStateClassType().getDescriptor(), null, l_savedState, l_ret, lv_savedState));
        return node;
    }

    public List<MethodNode> methodNodes() {
        return this.methodNodes;
    }

    static abstract class ConstFieldInstance {
        private final Object value;
        private final String fieldName;
        private final Type ownerClassType;
        private final Type fieldType;

        public ConstFieldInstance(Object value, String fieldName, Type ownerClassType, Type fieldType) {
            this.value = Objects.requireNonNull(value);
            this.fieldName = Objects.requireNonNull(fieldName);
            this.ownerClassType = Objects.requireNonNull(ownerClassType);
            this.fieldType = Objects.requireNonNull(fieldType);
        }

        public Object value() {
            return this.value;
        }

        public FieldNode fieldNode() {
            return new FieldNode(26, this.fieldName, this.fieldType.getDescriptor(), null, null);
        }

        public abstract void doInstantiate(InsnList var1);

        public InsnList instantiateInsns() {
            InsnList il = new InsnList();
            this.doInstantiate(il);
            il.add(new FieldInsnNode(179, this.ownerClassType.getInternalName(), this.fieldName, this.fieldType.getDescriptor()));
            return il;
        }

        public InsnList accessInsns() {
            InsnList il = new InsnList();
            il.add(new FieldInsnNode(178, this.ownerClassType.getInternalName(), this.fieldName, this.fieldType.getDescriptor()));
            return il;
        }
    }

    static class ClosureFieldInstance {
        private final FieldNode fieldNode;
        private final InsnList instantiateInsns;

        public ClosureFieldInstance(FieldNode fieldNode, InsnList instantiateInsns) {
            this.fieldNode = Objects.requireNonNull(fieldNode);
            this.instantiateInsns = Objects.requireNonNull(instantiateInsns);
        }

        public FieldNode fieldNode() {
            return this.fieldNode;
        }

        public InsnList instantiateInsns() {
            return this.instantiateInsns;
        }
    }

    static interface LabelResolver {
        public boolean isLocalLabel(Label var1);

        public int labelStateIndex(Label var1);
    }
}

