/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.classdump.luna.compiler.ir.BlockTermNode;
import org.classdump.luna.compiler.ir.IRVisitor;
import org.classdump.luna.compiler.ir.JmpNode;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.compiler.ir.Val;

public class Branch
extends BlockTermNode
implements JmpNode {
    private final Condition condition;
    private final Label branch;
    private final Label next;

    public Branch(Condition condition, Label branch, Label next) {
        this.condition = Objects.requireNonNull(condition);
        this.branch = Objects.requireNonNull(branch);
        this.next = Objects.requireNonNull(next);
    }

    public Condition condition() {
        return this.condition;
    }

    @Override
    public Label jmpDest() {
        return this.branch;
    }

    public Label next() {
        return this.next;
    }

    @Override
    public Iterable<Label> nextLabels() {
        ArrayList<Label> tmp = new ArrayList<Label>(2);
        tmp.add(this.next());
        tmp.add(this.jmpDest());
        return Collections.unmodifiableList(tmp);
    }

    @Override
    public void accept(IRVisitor visitor) {
        visitor.visit(this);
    }

    public static abstract class Condition {
        private Condition() {
        }

        public abstract void accept(IRVisitor var1);

        public static class NumLoopEnd
        extends Condition {
            private final Val var;
            private final Val limit;
            private final Val step;

            public NumLoopEnd(Val var, Val limit, Val step) {
                this.var = Objects.requireNonNull(var);
                this.limit = Objects.requireNonNull(limit);
                this.step = Objects.requireNonNull(step);
            }

            public Val var() {
                return this.var;
            }

            public Val limit() {
                return this.limit;
            }

            public Val step() {
                return this.step;
            }

            @Override
            public void accept(IRVisitor visitor) {
                visitor.visit(this);
            }
        }

        public static class Bool
        extends Condition {
            private final Val addr;
            private final boolean expected;

            public Bool(Val addr, boolean expected) {
                this.addr = Objects.requireNonNull(addr);
                this.expected = expected;
            }

            public Val addr() {
                return this.addr;
            }

            public boolean expected() {
                return this.expected;
            }

            @Override
            public void accept(IRVisitor visitor) {
                visitor.visit(this);
            }
        }

        public static class Nil
        extends Condition {
            private final Val addr;

            public Nil(Val addr) {
                this.addr = Objects.requireNonNull(addr);
            }

            public Val addr() {
                return this.addr;
            }

            @Override
            public void accept(IRVisitor visitor) {
                visitor.visit(this);
            }
        }
    }
}

