/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.tf;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.classdump.luna.compiler.IRFunc;
import org.classdump.luna.compiler.ir.BasicBlock;
import org.classdump.luna.compiler.ir.BodyNode;
import org.classdump.luna.compiler.ir.Code;
import org.classdump.luna.compiler.ir.Label;
import org.classdump.luna.compiler.ir.ToNext;

public abstract class CodeSimplifier {
    private CodeSimplifier() {
    }

    private static boolean visit(Map<Label, Integer> uses, Label l) {
        Integer n = uses.get(l);
        if (n != null) {
            uses.put(l, n + 1);
            return false;
        }
        uses.put(l, 1);
        return true;
    }

    private static Map<Label, Integer> uses(Code code) {
        HashMap<Label, Integer> uses = new HashMap<Label, Integer>();
        ArrayDeque<Label> open = new ArrayDeque<Label>();
        open.add(code.entryLabel());
        while (!open.isEmpty()) {
            Label l = (Label)open.pop();
            if (!CodeSimplifier.visit(uses, l)) continue;
            BasicBlock b = code.block(l);
            for (Label n : b.end().nextLabels()) {
                open.add(n);
            }
        }
        return uses;
    }

    static Code pruneUnreachableCode(Code code) {
        Objects.requireNonNull(code);
        Set<Label> reachable = CodeSimplifier.uses(code).keySet();
        ArrayList<BasicBlock> result = new ArrayList<BasicBlock>();
        Iterator<BasicBlock> it = code.blockIterator();
        while (it.hasNext()) {
            BasicBlock b = it.next();
            if (!reachable.contains(b.label())) continue;
            result.add(b);
        }
        return Code.of(result);
    }

    public static IRFunc pruneUnreachableCode(IRFunc fn) {
        return fn.update(CodeSimplifier.pruneUnreachableCode(fn.code()));
    }

    private static BasicBlock merge(BasicBlock a, BasicBlock b) {
        Objects.requireNonNull(a);
        Objects.requireNonNull(b);
        if (a.end() instanceof ToNext) {
            ArrayList<BodyNode> body = new ArrayList<BodyNode>();
            body.addAll(a.body());
            body.addAll(b.body());
            return new BasicBlock(a.label(), body, b.end());
        }
        return null;
    }

    private static <T> T nextOrNull(Iterator<T> it) {
        return it.hasNext() ? (T)it.next() : null;
    }

    static Code mergeBlocks(Code code) {
        Objects.requireNonNull(code);
        Map<Label, Integer> uses = CodeSimplifier.uses(code);
        ArrayList<BasicBlock> result = new ArrayList<BasicBlock>();
        Iterator<BasicBlock> it = code.blockIterator();
        BasicBlock a = it.next();
        BasicBlock b = CodeSimplifier.nextOrNull(it);
        while (b != null) {
            if (uses.get(b.label()) < 2) {
                BasicBlock ab = CodeSimplifier.merge(a, b);
                if (ab != null) {
                    a = ab;
                } else {
                    result.add(a);
                    a = b;
                }
            } else {
                result.add(a);
                a = b;
            }
            b = CodeSimplifier.nextOrNull(it);
        }
        assert (a != null);
        assert (b == null);
        result.add(a);
        return Code.of(result);
    }

    public static IRFunc mergeBlocks(IRFunc fn) {
        return fn.update(CodeSimplifier.mergeBlocks(fn.code()));
    }
}

