/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.tf;

import java.util.Objects;
import org.classdump.luna.ByteString;
import org.classdump.luna.compiler.analysis.TypeInfo;
import org.classdump.luna.compiler.analysis.types.LiteralType;
import org.classdump.luna.compiler.analysis.types.Type;
import org.classdump.luna.compiler.ir.BinOp;
import org.classdump.luna.compiler.ir.BodyNode;
import org.classdump.luna.compiler.ir.LoadConst;
import org.classdump.luna.compiler.ir.ToNumber;
import org.classdump.luna.compiler.ir.UnOp;
import org.classdump.luna.compiler.ir.Val;
import org.classdump.luna.compiler.tf.CodeTransformerVisitor;

public class ConstFolderVisitor
extends CodeTransformerVisitor {
    private final TypeInfo typeInfo;

    public ConstFolderVisitor(TypeInfo typeInfo) {
        this.typeInfo = Objects.requireNonNull(typeInfo);
    }

    private static LoadConst objectToLoadConstNode(Val dest, Object o) {
        Objects.requireNonNull(dest);
        if (o instanceof Number) {
            Number n = (Number)o;
            if (n instanceof Double || n instanceof Float) {
                return new LoadConst.Flt(dest, n.doubleValue());
            }
            return new LoadConst.Int(dest, n.longValue());
        }
        if (o instanceof ByteString) {
            return new LoadConst.Str(dest, (ByteString)o);
        }
        if (o instanceof Boolean) {
            return new LoadConst.Bool(dest, (Boolean)o);
        }
        return null;
    }

    private void replace(BodyNode oldNode, BodyNode newNode) {
        Objects.requireNonNull(oldNode);
        Objects.requireNonNull(newNode);
        int idx = this.currentBody().indexOf(oldNode);
        if (idx < 0) {
            throw new IllegalStateException("Body node not found in current block: " + oldNode);
        }
        this.currentBody().set(idx, newNode);
    }

    private void replaceIfLiteral(BodyNode node, Val v) {
        LiteralType lt;
        LoadConst loadNode;
        Type resultType = this.typeInfo.typeOf(v);
        if (resultType instanceof LiteralType && (loadNode = ConstFolderVisitor.objectToLoadConstNode(v, (lt = (LiteralType)resultType).value())) != null) {
            this.replace(node, loadNode);
        }
    }

    @Override
    public void visit(BinOp node) {
        this.replaceIfLiteral(node, node.dest());
    }

    @Override
    public void visit(UnOp node) {
        this.replaceIfLiteral(node, node.dest());
    }

    @Override
    public void visit(ToNumber node) {
        this.replaceIfLiteral(node, node.dest());
    }
}

