/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.compiler.tf;

import java.util.Objects;
import org.classdump.luna.compiler.analysis.LivenessInfo;
import org.classdump.luna.compiler.analysis.TypeInfo;
import org.classdump.luna.compiler.ir.AbstractVal;
import org.classdump.luna.compiler.ir.BodyNode;
import org.classdump.luna.compiler.ir.IRNode;
import org.classdump.luna.compiler.ir.LoadConst;
import org.classdump.luna.compiler.ir.MultiGet;
import org.classdump.luna.compiler.ir.Var;
import org.classdump.luna.compiler.ir.VarInit;
import org.classdump.luna.compiler.ir.VarLoad;
import org.classdump.luna.compiler.ir.VarStore;
import org.classdump.luna.compiler.tf.CodeTransformerVisitor;

public class DeadCodePrunerVisitor
extends CodeTransformerVisitor {
    private final TypeInfo types;
    private final LivenessInfo liveness;

    public DeadCodePrunerVisitor(TypeInfo types, LivenessInfo liveness) {
        this.types = Objects.requireNonNull(types);
        this.liveness = Objects.requireNonNull(liveness);
    }

    protected void skip(BodyNode node) {
        int idx = this.currentBody().indexOf(node);
        if (idx < 0) {
            throw new IllegalStateException("Node not found: " + node);
        }
        this.currentBody().remove(idx);
    }

    protected boolean isLiveOut(IRNode at, AbstractVal v) {
        return this.liveness.entry(at).outVal().contains(v);
    }

    protected boolean isLiveOut(IRNode at, Var v) {
        return this.liveness.entry(at).outVar().contains(v);
    }

    @Override
    public void visit(LoadConst.Nil node) {
        if (!this.isLiveOut((IRNode)node, node.dest())) {
            this.skip(node);
        }
    }

    @Override
    public void visit(LoadConst.Bool node) {
        if (!this.isLiveOut((IRNode)node, node.dest())) {
            this.skip(node);
        }
    }

    @Override
    public void visit(LoadConst.Int node) {
        if (!this.isLiveOut((IRNode)node, node.dest())) {
            this.skip(node);
        }
    }

    @Override
    public void visit(LoadConst.Flt node) {
        if (!this.isLiveOut((IRNode)node, node.dest())) {
            this.skip(node);
        }
    }

    @Override
    public void visit(LoadConst.Str node) {
        if (!this.isLiveOut((IRNode)node, node.dest())) {
            this.skip(node);
        }
    }

    @Override
    public void visit(VarInit node) {
        if (!this.types.isReified(node.var()) && !this.isLiveOut((IRNode)node, node.var())) {
            this.skip(node);
        }
    }

    @Override
    public void visit(VarStore node) {
        if (!this.types.isReified(node.var()) && !this.isLiveOut((IRNode)node, node.var())) {
            this.skip(node);
        }
    }

    @Override
    public void visit(VarLoad node) {
        if (!this.types.isReified(node.var()) && !this.isLiveOut((IRNode)node, node.dest())) {
            this.skip(node);
        }
    }

    @Override
    public void visit(MultiGet node) {
        if (!this.isLiveOut((IRNode)node, node.dest())) {
            this.skip(node);
        }
    }
}

