/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.env;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import org.classdump.luna.env.RuntimeEnvironment;

class SystemRuntimeEnvironment
implements RuntimeEnvironment {
    private final InputStream in;
    private final OutputStream out;
    private final OutputStream err;
    private static final SystemRuntimeEnvironment INSTANCE = new SystemRuntimeEnvironment(System.in, System.out, System.err);

    SystemRuntimeEnvironment(InputStream in, OutputStream out, OutputStream err) {
        this.in = in;
        this.out = out;
        this.err = err;
    }

    public static SystemRuntimeEnvironment getInstance() {
        return INSTANCE;
    }

    @Override
    public InputStream standardInput() {
        return this.in;
    }

    @Override
    public OutputStream standardOutput() {
        return this.out;
    }

    @Override
    public OutputStream standardError() {
        return this.err;
    }

    @Override
    public FileSystem fileSystem() {
        return FileSystems.getDefault();
    }

    @Override
    public String getEnv(String name) {
        return System.getenv(name);
    }

    @Override
    public double getCpuTime() {
        long nanos = ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime();
        return (double)nanos / 1.0E9;
    }
}

