/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.exec;

import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.classdump.luna.Conversions;
import org.classdump.luna.StateContext;
import org.classdump.luna.exec.CallEventHandler;
import org.classdump.luna.exec.CallException;
import org.classdump.luna.exec.CallPausedException;
import org.classdump.luna.exec.Continuation;
import org.classdump.luna.impl.ReturnBuffers;
import org.classdump.luna.impl.SchedulingContexts;
import org.classdump.luna.runtime.AsyncTask;
import org.classdump.luna.runtime.ReturnBufferFactory;
import org.classdump.luna.runtime.RuntimeCallInitialiser;
import org.classdump.luna.runtime.SchedulingContext;
import org.classdump.luna.runtime.SchedulingContextFactory;

public class DirectCallExecutor {
    private final SchedulingContextFactory schedulingContextFactory;
    private final ReturnBufferFactory returnBufferFactory;
    private final boolean performJavaConversions;
    private static final ReturnBufferFactory DEFAULT_RETURN_BUFFER_FACTORY = ReturnBuffers.defaultFactory();
    private static final DirectCallExecutor NEVER_PAUSING_EXECUTOR = new DirectCallExecutor(SchedulingContexts.neverPauseFactory());

    DirectCallExecutor(SchedulingContextFactory schedulingContextFactory) {
        this.schedulingContextFactory = Objects.requireNonNull(schedulingContextFactory);
        this.returnBufferFactory = DEFAULT_RETURN_BUFFER_FACTORY;
        this.performJavaConversions = true;
    }

    public static DirectCallExecutor newExecutor() {
        return NEVER_PAUSING_EXECUTOR;
    }

    public static DirectCallExecutor newExecutor(SchedulingContextFactory schedulingContextFactory) {
        return new DirectCallExecutor(schedulingContextFactory);
    }

    public static DirectCallExecutor newExecutorWithTickLimit(long ticksLimit) {
        return DirectCallExecutor.newExecutor(SchedulingContexts.countDownContextFactory(ticksLimit));
    }

    public SchedulingContextFactory schedulingContextFactory() {
        return this.schedulingContextFactory;
    }

    public Object[] call(StateContext stateContext, Object fn, Object ... args) throws CallException, CallPausedException, InterruptedException {
        RuntimeCallInitialiser initialiser = RuntimeCallInitialiser.forState(stateContext, this.returnBufferFactory);
        return this.resume(initialiser.newCall(this.performJavaConversions ? Conversions.canonicalRepresentationOf(fn) : fn, this.performJavaConversions ? Conversions.copyAsCanonicalValues(args) : args));
    }

    public Object[] resume(Continuation continuation) throws CallException, CallPausedException, InterruptedException {
        return DirectCallExecutor.execute(continuation, this.schedulingContextFactory.newInstance(), this.performJavaConversions);
    }

    public static Object[] execute(Continuation continuation, SchedulingContext schedulingContext, boolean convertResultsToJava) throws CallException, CallPausedException, InterruptedException {
        Result result;
        Objects.requireNonNull(continuation);
        Objects.requireNonNull(schedulingContext);
        while (true) {
            result = new Result();
            continuation.resume(result, schedulingContext);
            if (!result.wasSet.get() || result.task == null || result.cont == null) break;
            final CountDownLatch latch = new CountDownLatch(1);
            AsyncTask.ContinueCallback callback = new AsyncTask.ContinueCallback(){

                @Override
                public void finished() {
                    latch.countDown();
                }
            };
            continuation = result.cont;
            result.task.execute(callback);
            latch.await();
        }
        Object[] values = result.get();
        if (convertResultsToJava) {
            Conversions.toJavaValues(values);
        }
        return values;
    }

    public static Object[] execute(Continuation continuation, SchedulingContext schedulingContext) throws CallException, CallPausedException, InterruptedException {
        return DirectCallExecutor.execute(continuation, schedulingContext, true);
    }

    public static Object[] execute(Continuation continuation) throws CallException, CallPausedException, InterruptedException {
        return DirectCallExecutor.execute(continuation, SchedulingContexts.neverPause());
    }

    private static class Result
    implements CallEventHandler {
        private final AtomicBoolean wasSet = new AtomicBoolean(false);
        private Continuation cont = null;
        private Object[] values = null;
        private Throwable error = null;
        private AsyncTask task = null;

        Result() {
        }

        @Override
        public void returned(Object id, Object[] result) {
            if (result != null) {
                if (!this.wasSet.compareAndSet(false, true)) {
                    throw new IllegalStateException("Call result already set");
                }
            } else {
                throw new IllegalArgumentException("Return values array must not be null");
            }
            this.values = result;
        }

        @Override
        public void failed(Object id, Throwable error) {
            if (error != null) {
                if (!this.wasSet.compareAndSet(false, true)) {
                    throw new IllegalStateException("Call result already set");
                }
            } else {
                throw new IllegalArgumentException("Error must not be null");
            }
            this.error = error;
        }

        @Override
        public void paused(Object id, Continuation cont) {
            if (cont != null) {
                if (!this.wasSet.compareAndSet(false, true)) {
                    throw new IllegalStateException("Call result already set");
                }
            } else {
                throw new IllegalArgumentException("Continuation must not be null");
            }
            this.cont = cont;
        }

        @Override
        public void async(Object id, Continuation cont, AsyncTask task) {
            if (cont != null && task != null) {
                if (!this.wasSet.compareAndSet(false, true)) {
                    throw new IllegalStateException("Call result already set");
                }
            } else {
                throw new IllegalArgumentException("Continuation and task must not be null");
            }
            this.cont = cont;
            this.task = task;
        }

        public Object[] get() throws CallException, CallPausedException {
            if (!this.wasSet.get()) {
                throw new IllegalStateException("Call result has not been set");
            }
            if (this.values != null) {
                return this.values;
            }
            if (this.cont != null) {
                throw new CallPausedException(this.cont);
            }
            if (this.error != null) {
                throw new CallException(this.error);
            }
            throw new AssertionError();
        }
    }
}

