/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.classdump.luna.Conversions;
import org.classdump.luna.Table;
import org.classdump.luna.TableFactory;
import org.classdump.luna.util.TraversableHashMap;

public class ImmutableTable
extends Table {
    private final Map<Object, Entry> entries;
    private final Object initialKey;

    ImmutableTable(Map<Object, Entry> entries, Object initialKey) {
        this.entries = Objects.requireNonNull(entries);
        this.initialKey = initialKey;
    }

    public static ImmutableTable of(Iterable<Map.Entry<Object, Object>> entries) {
        Builder builder = new Builder();
        for (Map.Entry<Object, Object> entry : entries) {
            builder.add(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    public static ImmutableTable of(Map<Object, Object> map) {
        return ImmutableTable.of(map.entrySet());
    }

    public Table newCopy(TableFactory tableFactory) {
        Table t = tableFactory.newTable();
        for (Object key : this.entries.keySet()) {
            Entry e = this.entries.get(key);
            t.rawset(key, e.value);
        }
        return t;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableTable that = (ImmutableTable)o;
        return this.entries.equals(that.entries) && (this.initialKey != null ? this.initialKey.equals(that.initialKey) : that.initialKey == null);
    }

    public int hashCode() {
        int result = this.entries.hashCode();
        result = 31 * result + (this.initialKey != null ? this.initialKey.hashCode() : 0);
        return result;
    }

    @Override
    public Object rawget(Object key) {
        Entry e = this.entries.get(key = Conversions.normaliseKey(key));
        return e != null ? e.value : null;
    }

    @Override
    public void rawset(Object key, Object value) {
        throw new UnsupportedOperationException("table is immutable");
    }

    @Override
    public void rawset(long idx, Object value) {
        throw new UnsupportedOperationException("table is immutable");
    }

    @Override
    public Table getMetatable() {
        return null;
    }

    @Override
    public Table setMetatable(Table mt) {
        throw new UnsupportedOperationException("table is immutable");
    }

    @Override
    public Object initialKey() {
        return this.initialKey;
    }

    @Override
    public Object successorKeyOf(Object key) {
        key = Conversions.normaliseKey(key);
        try {
            Entry e = this.entries.get(key);
            return e.nextKey;
        }
        catch (NullPointerException ex) {
            throw new IllegalArgumentException("invalid key to 'next'", ex);
        }
    }

    @Override
    protected void setMode(boolean weakKeys, boolean weakValues) {
    }

    public static class Builder {
        private final TraversableHashMap<Object, Object> entries;

        private static void checkKey(Object key) {
            if (key == null || key instanceof Double && Double.isNaN((Double)key)) {
                throw new IllegalArgumentException("invalid table key: " + Conversions.toHumanReadableString(key));
            }
        }

        private Builder(TraversableHashMap<Object, Object> entries) {
            this.entries = Objects.requireNonNull(entries);
        }

        public Builder() {
            this(new TraversableHashMap<Object, Object>());
        }

        private static <K, V> TraversableHashMap<K, V> mapCopy(TraversableHashMap<K, V> map) {
            TraversableHashMap<K, V> result = new TraversableHashMap<K, V>();
            result.putAll(map);
            return result;
        }

        public Builder(Builder builder) {
            this(Builder.mapCopy(builder.entries));
        }

        public Builder add(Object key, Object value) {
            key = Conversions.normaliseKey(key);
            Builder.checkKey(key);
            if (value != null) {
                this.entries.put(key, value);
            } else {
                this.entries.remove(key);
            }
            return this;
        }

        public void clear() {
            this.entries.clear();
        }

        public ImmutableTable build() {
            HashMap<Object, Entry> tableEntries = new HashMap<Object, Entry>();
            for (Map.Entry<Object, Object> e : this.entries.entrySet()) {
                Object k = e.getKey();
                tableEntries.put(e.getKey(), new Entry(e.getValue(), this.entries.getSuccessorOf(k)));
            }
            return new ImmutableTable(Collections.unmodifiableMap(tableEntries), this.entries.getFirstKey());
        }
    }

    static class Entry {
        private final Object value;
        private final Object nextKey;

        private Entry(Object value, Object nextKey) {
            this.value = Objects.requireNonNull(value);
            this.nextKey = nextKey;
        }
    }
}

