/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.impl;

import org.classdump.luna.runtime.SchedulingContext;
import org.classdump.luna.runtime.SchedulingContextFactory;
import org.classdump.luna.util.Check;

public final class SchedulingContexts {
    private static final SchedulingContext NEVER_INSTANCE = new NeverPausingSchedulingContext();
    private static final SchedulingContext ALWAYS_INSTANCE = new AlwaysPausingSchedulingContext();
    private static final SchedulingContextFactory NEVER_FACTORY = new SchedulingContextFactory(){

        @Override
        public SchedulingContext newInstance() {
            return SchedulingContexts.neverPause();
        }
    };
    private static final SchedulingContextFactory ALWAYS_FACTORY = new SchedulingContextFactory(){

        @Override
        public SchedulingContext newInstance() {
            return SchedulingContexts.alwaysPause();
        }
    };

    private SchedulingContexts() {
    }

    public static SchedulingContext neverPause() {
        return NEVER_INSTANCE;
    }

    public static SchedulingContext alwaysPause() {
        return ALWAYS_INSTANCE;
    }

    public static SchedulingContext newCountDownContext(long max) {
        return new CountDownSchedulingContext(max);
    }

    public static SchedulingContextFactory neverPauseFactory() {
        return NEVER_FACTORY;
    }

    public static SchedulingContextFactory alwaysPauseFactory() {
        return ALWAYS_FACTORY;
    }

    public static SchedulingContextFactory countDownContextFactory(final long max) {
        Check.nonNegative(max);
        return new SchedulingContextFactory(){

            @Override
            public SchedulingContext newInstance() {
                return SchedulingContexts.newCountDownContext(max);
            }
        };
    }

    private static class CountDownSchedulingContext
    implements SchedulingContext {
        private long allowance;

        public CountDownSchedulingContext(long max) {
            Check.nonNegative(max);
            this.allowance = max;
        }

        @Override
        public void registerTicks(int ticks) {
            this.allowance -= (long)Math.max(0, ticks);
        }

        @Override
        public boolean shouldPause() {
            return this.allowance <= 0L;
        }
    }

    private static class AlwaysPausingSchedulingContext
    implements SchedulingContext {
        private AlwaysPausingSchedulingContext() {
        }

        @Override
        public void registerTicks(int ticks) {
        }

        @Override
        public boolean shouldPause() {
            return true;
        }
    }

    private static class NeverPausingSchedulingContext
    implements SchedulingContext {
        private NeverPausingSchedulingContext() {
        }

        @Override
        public void registerTicks(int ticks) {
        }

        @Override
        public boolean shouldPause() {
            return false;
        }
    }
}

