/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib;

import java.util.Objects;
import org.classdump.luna.StateContext;
import org.classdump.luna.Table;
import org.classdump.luna.env.RuntimeEnvironment;
import org.classdump.luna.lib.BasicLib;
import org.classdump.luna.lib.CoroutineLib;
import org.classdump.luna.lib.DebugLib;
import org.classdump.luna.lib.IoLib;
import org.classdump.luna.lib.MathLib;
import org.classdump.luna.lib.ModuleLib;
import org.classdump.luna.lib.OsLib;
import org.classdump.luna.lib.StringLib;
import org.classdump.luna.lib.TableLib;
import org.classdump.luna.lib.Utf8Lib;
import org.classdump.luna.load.ChunkLoader;

public class StandardLibrary {
    private final RuntimeEnvironment environment;
    private final ChunkLoader chunkLoader;
    private final ClassLoader moduleLoader;
    private final boolean withDebug;

    private StandardLibrary(RuntimeEnvironment environment, ChunkLoader chunkLoader, ClassLoader moduleLoader, boolean withDebug) {
        this.environment = Objects.requireNonNull(environment);
        this.chunkLoader = chunkLoader;
        this.moduleLoader = moduleLoader;
        this.withDebug = withDebug;
    }

    private StandardLibrary(RuntimeEnvironment environment) {
        this(environment, null, null, false);
    }

    public static StandardLibrary in(RuntimeEnvironment environment) {
        return new StandardLibrary(environment);
    }

    public StandardLibrary withLoader(ChunkLoader chunkLoader) {
        return this.chunkLoader != chunkLoader ? new StandardLibrary(this.environment, chunkLoader, this.moduleLoader, this.withDebug) : this;
    }

    public StandardLibrary withModuleLoader(ClassLoader moduleLoader) {
        return this.moduleLoader != moduleLoader ? new StandardLibrary(this.environment, this.chunkLoader, moduleLoader, this.withDebug) : this;
    }

    public StandardLibrary withDebug(boolean hasDebug) {
        return this.withDebug != hasDebug ? new StandardLibrary(this.environment, this.chunkLoader, this.moduleLoader, hasDebug) : this;
    }

    public Table installInto(StateContext state) {
        Objects.requireNonNull(state);
        Table env = state.newTable();
        BasicLib.installInto(state, env, this.environment, this.chunkLoader);
        ModuleLib.installInto(state, env, this.environment, this.chunkLoader, this.moduleLoader);
        CoroutineLib.installInto(state, env);
        StringLib.installInto(state, env);
        MathLib.installInto(state, env);
        TableLib.installInto(state, env);
        IoLib.installInto(state, env, this.environment);
        OsLib.installInto(state, env, this.environment);
        Utf8Lib.installInto(state, env);
        if (this.withDebug) {
            DebugLib.installInto(state, env);
        }
        return env;
    }
}

