/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.lib.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.classdump.luna.lib.io.SeekableStream;

public class SeekableInputStream
extends InputStream
implements SeekableStream {
    private final InputStream in;
    private long position;

    public SeekableInputStream(InputStream in) {
        this.in = Objects.requireNonNull(in);
        this.position = 0L;
    }

    @Override
    public int read() throws IOException {
        int result = this.in.read();
        if (result != -1) {
            ++this.position;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return super.read(b, off, len);
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public long setPosition(long newPosition) {
        this.position = newPosition;
        return this.position;
    }

    @Override
    public long addPosition(long offset) {
        long newPosition = this.position + offset;
        if (this.position < 0L) {
            throw new IllegalArgumentException("Illegal argument");
        }
        return this.setPosition(newPosition);
    }
}

