/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.load;

public class LoaderException
extends Exception {
    private final String sourceFileName;
    private final int sourceLine;
    private final boolean partialInput;

    public LoaderException(Throwable cause, String sourceFileName, int sourceLine, boolean partialInput) {
        super(cause);
        this.sourceFileName = sourceFileName;
        this.sourceLine = sourceLine;
        this.partialInput = partialInput;
    }

    public LoaderException(Throwable cause, String sourceFileName) {
        this(cause, sourceFileName, 0, false);
    }

    public boolean isPartialInputError() {
        return this.partialInput;
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public int getSourceLine() {
        return this.sourceLine;
    }

    public String getLuaStyleErrorMessage() {
        Throwable cause = this.getCause();
        String prefix = this.sourceFileName != null ? this.sourceFileName + ":" + (this.sourceLine > 0 ? Integer.toString(this.sourceLine) : "?") + ": " : "";
        return prefix + cause.getMessage();
    }
}

