/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser;

import java.util.List;
import org.classdump.luna.parser.ast.Attributes;
import org.classdump.luna.parser.ast.BinaryOperationExpr;
import org.classdump.luna.parser.ast.Block;
import org.classdump.luna.parser.ast.CallExpr;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.FunctionDefExpr;
import org.classdump.luna.parser.ast.IndexExpr;
import org.classdump.luna.parser.ast.Literal;
import org.classdump.luna.parser.ast.LiteralExpr;
import org.classdump.luna.parser.ast.MultiExpr;
import org.classdump.luna.parser.ast.Name;
import org.classdump.luna.parser.ast.Operator;
import org.classdump.luna.parser.ast.ParenExpr;
import org.classdump.luna.parser.ast.SourceInfo;
import org.classdump.luna.parser.ast.TableConstructorExpr;
import org.classdump.luna.parser.ast.UnaryOperationExpr;
import org.classdump.luna.parser.ast.VarExpr;
import org.classdump.luna.parser.ast.VarargsExpr;

public abstract class Exprs {
    private Exprs() {
    }

    private static Attributes attr(SourceInfo src) {
        return Attributes.of(src);
    }

    public static LiteralExpr literal(SourceInfo src, Literal value) {
        return new LiteralExpr(Exprs.attr(src), value);
    }

    public static FunctionDefExpr functionDef(SourceInfo src, FunctionDefExpr.Params params, Block block) {
        return new FunctionDefExpr(Exprs.attr(src), params, block);
    }

    public static TableConstructorExpr tableConstructor(SourceInfo src, List<TableConstructorExpr.FieldInitialiser> fields) {
        return new TableConstructorExpr(Exprs.attr(src), fields);
    }

    public static TableConstructorExpr.FieldInitialiser fieldInitialiser(Expr keyExpr, Expr valueExpr) {
        return new TableConstructorExpr.FieldInitialiser(keyExpr, valueExpr);
    }

    public static IndexExpr index(SourceInfo src, Expr object, Expr key) {
        return new IndexExpr(Exprs.attr(src), object, key);
    }

    public static VarExpr var(SourceInfo src, Name name) {
        return new VarExpr(Exprs.attr(src), name);
    }

    public static VarargsExpr varargs(SourceInfo src) {
        return new VarargsExpr(Exprs.attr(src));
    }

    public static CallExpr.FunctionCallExpr functionCall(SourceInfo src, Expr fn, List<Expr> args) {
        return new CallExpr.FunctionCallExpr(Exprs.attr(src), fn, args);
    }

    public static CallExpr.MethodCallExpr methodCall(SourceInfo src, Expr target, Name methodName, List<Expr> args) {
        return new CallExpr.MethodCallExpr(Exprs.attr(src), target, methodName, args);
    }

    public static Expr paren(Expr expr) {
        if (expr instanceof MultiExpr) {
            return new ParenExpr(expr.attributes(), (MultiExpr)expr);
        }
        return expr;
    }

    public static BinaryOperationExpr binaryOperation(SourceInfo src, Operator.Binary op, Expr left, Expr right) {
        return new BinaryOperationExpr(Exprs.attr(src), op, left, right);
    }

    public static UnaryOperationExpr unaryOperation(SourceInfo src, Operator.Unary op, Expr arg) {
        return new UnaryOperationExpr(Exprs.attr(src), op, arg);
    }
}

