/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser;

import java.util.Objects;
import org.classdump.luna.parser.Exprs;
import org.classdump.luna.parser.SourceElement;
import org.classdump.luna.parser.ast.LValueExpr;
import org.classdump.luna.parser.ast.Name;
import org.classdump.luna.parser.ast.SourceInfo;
import org.classdump.luna.parser.ast.StringLiteral;

class FunctionNameBuilder {
    private LValueExpr lv;
    private boolean method;

    public FunctionNameBuilder(SourceElement<Name> srcName) {
        Objects.requireNonNull(srcName);
        this.lv = Exprs.var(srcName.sourceInfo(), srcName.element());
        this.method = false;
    }

    public void addDotName(SourceInfo srcDot, SourceElement<Name> srcName) {
        Objects.requireNonNull(srcDot);
        Objects.requireNonNull(srcName);
        this.lv = Exprs.index(srcDot, this.lv, Exprs.literal(srcName.sourceInfo(), StringLiteral.fromName(srcName.element())));
    }

    public void addColonName(SourceInfo srcColon, SourceElement<Name> srcName) {
        this.addDotName(srcColon, srcName);
        this.method = true;
    }

    public boolean isMethod() {
        return this.method;
    }

    public LValueExpr get() {
        return this.lv;
    }
}

