/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.ast;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Attributes {
    private final Map<Class<?>, Object> attribs;
    private static final Attributes EMPTY = new Attributes(Collections.emptyMap());

    private Attributes(Map<Class<?>, Object> attribs) {
        this.attribs = Objects.requireNonNull(attribs);
    }

    public static Attributes empty() {
        return EMPTY;
    }

    public static Attributes of(Object ... objects) {
        if (objects.length > 0) {
            HashMap as = new HashMap();
            for (Object o : objects) {
                as.put(o.getClass(), o);
            }
            return new Attributes(Collections.unmodifiableMap(as));
        }
        return Attributes.empty();
    }

    public Attributes with(Object o) {
        Objects.requireNonNull(o);
        Class<?> clazz = o.getClass();
        if (Objects.equals(this.attribs.get(clazz), o)) {
            return this;
        }
        HashMap as = new HashMap();
        as.putAll(this.attribs);
        as.put(clazz, o);
        return new Attributes(Collections.unmodifiableMap(as));
    }

    public <T> T get(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        Object result = this.attribs.get(clazz);
        if (result != null) {
            if (clazz.isAssignableFrom(result.getClass())) {
                Object r = result;
                return (T)r;
            }
            throw new IllegalStateException("Illegal entry for " + clazz.getName());
        }
        return null;
    }

    public boolean has(Class<?> clazz) {
        return this.get(clazz) != null;
    }
}

