/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.ast;

import java.util.Objects;
import org.classdump.luna.LuaFormat;

public final class Name {
    private final String value;

    private Name(String value) {
        this.value = Name.checkValidName(value);
    }

    public static Name fromString(String s) {
        return new Name(s);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Name name = (Name)o;
        return Objects.equals(this.value, name.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public static String checkValidName(String s) {
        if (!LuaFormat.isValidName(s)) {
            throw new IllegalArgumentException("Not a valid name: " + s);
        }
        return s;
    }

    public String value() {
        return this.value;
    }
}

