/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.parser.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.classdump.luna.parser.ast.AssignStatement;
import org.classdump.luna.parser.ast.BinaryOperationExpr;
import org.classdump.luna.parser.ast.Block;
import org.classdump.luna.parser.ast.BodyStatement;
import org.classdump.luna.parser.ast.BooleanLiteral;
import org.classdump.luna.parser.ast.BreakStatement;
import org.classdump.luna.parser.ast.CallExpr;
import org.classdump.luna.parser.ast.CallStatement;
import org.classdump.luna.parser.ast.Chunk;
import org.classdump.luna.parser.ast.ConditionalBlock;
import org.classdump.luna.parser.ast.DoStatement;
import org.classdump.luna.parser.ast.Expr;
import org.classdump.luna.parser.ast.FunctionDefExpr;
import org.classdump.luna.parser.ast.GenericForStatement;
import org.classdump.luna.parser.ast.GotoStatement;
import org.classdump.luna.parser.ast.IfStatement;
import org.classdump.luna.parser.ast.IndexExpr;
import org.classdump.luna.parser.ast.LValueExpr;
import org.classdump.luna.parser.ast.LabelStatement;
import org.classdump.luna.parser.ast.Literal;
import org.classdump.luna.parser.ast.LiteralExpr;
import org.classdump.luna.parser.ast.LocalDeclStatement;
import org.classdump.luna.parser.ast.MultiExpr;
import org.classdump.luna.parser.ast.Name;
import org.classdump.luna.parser.ast.NilLiteral;
import org.classdump.luna.parser.ast.Numeral;
import org.classdump.luna.parser.ast.NumericForStatement;
import org.classdump.luna.parser.ast.ParenExpr;
import org.classdump.luna.parser.ast.RepeatUntilStatement;
import org.classdump.luna.parser.ast.ReturnStatement;
import org.classdump.luna.parser.ast.StringLiteral;
import org.classdump.luna.parser.ast.TableConstructorExpr;
import org.classdump.luna.parser.ast.UnaryOperationExpr;
import org.classdump.luna.parser.ast.VarExpr;
import org.classdump.luna.parser.ast.VarargsExpr;
import org.classdump.luna.parser.ast.WhileStatement;

public abstract class Transformer {
    public Chunk transform(Chunk chunk) {
        return chunk.update(this.transform(chunk.block()));
    }

    public Block transform(Block block) {
        ArrayList<BodyStatement> stats = new ArrayList<BodyStatement>();
        for (BodyStatement bs : block.statements()) {
            stats.add(bs.accept(this));
        }
        ReturnStatement ret = block.returnStatement() != null ? block.returnStatement().accept(this) : null;
        return block.update(Collections.unmodifiableList(stats), ret);
    }

    public BodyStatement transform(DoStatement node) {
        return node.update(this.transform(node.block()));
    }

    public ReturnStatement transform(ReturnStatement node) {
        return node.update(this.transformExprList(node.exprs()));
    }

    public BodyStatement transform(AssignStatement node) {
        return node.update(this.transformVarList(node.vars()), this.transformExprList(node.exprs()));
    }

    public BodyStatement transform(LocalDeclStatement node) {
        return node.update(this.transformNameList(node.names()), this.transformExprList(node.initialisers()));
    }

    public BodyStatement transform(CallStatement node) {
        return node.update((CallExpr)node.callExpr().accept(this));
    }

    public ConditionalBlock transform(ConditionalBlock cb) {
        return cb.update(cb.condition().accept(this), this.transform(cb.block()));
    }

    protected List<ConditionalBlock> transformConditionalBlockList(List<ConditionalBlock> cbs) {
        ArrayList<ConditionalBlock> result = new ArrayList<ConditionalBlock>();
        for (ConditionalBlock cb : cbs) {
            result.add(this.transform(cb));
        }
        return Collections.unmodifiableList(result);
    }

    public BodyStatement transform(IfStatement node) {
        return node.update(this.transform(node.main()), this.transformConditionalBlockList(node.elifs()), node.elseBlock() != null ? this.transform(node.elseBlock()) : null);
    }

    public BodyStatement transform(NumericForStatement node) {
        return node.update(this.transform(node.name()), node.init().accept(this), node.limit().accept(this), node.step() != null ? node.step().accept(this) : null, this.transform(node.block()));
    }

    public BodyStatement transform(GenericForStatement node) {
        return node.update(this.transformNameList(node.names()), this.transformExprList(node.exprs()), this.transform(node.block()));
    }

    public BodyStatement transform(RepeatUntilStatement node) {
        return node.update(node.condition().accept(this), this.transform(node.block()));
    }

    public BodyStatement transform(WhileStatement node) {
        return node.update(node.condition().accept(this), this.transform(node.block()));
    }

    public BodyStatement transform(BreakStatement node) {
        return node;
    }

    public BodyStatement transform(LabelStatement node) {
        return node;
    }

    public BodyStatement transform(GotoStatement node) {
        return node;
    }

    protected List<Expr> transformExprList(List<Expr> exprs) {
        ArrayList<Expr> result = new ArrayList<Expr>();
        for (Expr e : exprs) {
            result.add(e.accept(this));
        }
        return Collections.unmodifiableList(result);
    }

    protected List<LValueExpr> transformVarList(List<LValueExpr> lvalues) {
        ArrayList<LValueExpr> result = new ArrayList<LValueExpr>();
        for (LValueExpr e : lvalues) {
            result.add(e.accept(this));
        }
        return Collections.unmodifiableList(result);
    }

    protected List<Name> transformNameList(List<Name> names) {
        ArrayList<Name> result = new ArrayList<Name>();
        for (Name n : names) {
            result.add(this.transform(n));
        }
        return Collections.unmodifiableList(result);
    }

    public Name transform(Name n) {
        return n;
    }

    public Expr transform(CallExpr.FunctionCallExpr e) {
        return e.update(e.fn().accept(this), this.transformExprList(e.args()));
    }

    public Expr transform(CallExpr.MethodCallExpr e) {
        return e.update(e.target().accept(this), e.methodName(), this.transformExprList(e.args()));
    }

    public LValueExpr transform(IndexExpr e) {
        return e.update(e.object().accept(this), e.key().accept(this));
    }

    public LValueExpr transform(VarExpr e) {
        return e;
    }

    public Expr transform(BinaryOperationExpr e) {
        return e.update(e.left().accept(this), e.right().accept(this));
    }

    public Expr transform(UnaryOperationExpr e) {
        return e.update(e.arg().accept(this));
    }

    public Expr transform(LiteralExpr e) {
        return e.update(e.value().accept(this));
    }

    public Expr transform(VarargsExpr e) {
        return e;
    }

    public Expr transform(ParenExpr e) {
        Expr f = e.multiExpr().accept(this);
        return f instanceof MultiExpr ? e.update((MultiExpr)f) : f;
    }

    public Expr transform(FunctionDefExpr e) {
        return e.update(this.transform(e.params()), this.transform(e.block()));
    }

    public FunctionDefExpr.Params transform(FunctionDefExpr.Params ps) {
        return ps.update(this.transformNameList(ps.names()), ps.isVararg());
    }

    public Expr transform(TableConstructorExpr e) {
        ArrayList<TableConstructorExpr.FieldInitialiser> result = new ArrayList<TableConstructorExpr.FieldInitialiser>();
        for (TableConstructorExpr.FieldInitialiser fi : e.fields()) {
            result.add(fi.update(fi.key() != null ? fi.key().accept(this) : null, fi.value().accept(this)));
        }
        return e.update(Collections.unmodifiableList(result));
    }

    public Literal transform(NilLiteral l) {
        return l;
    }

    public Literal transform(BooleanLiteral l) {
        return l;
    }

    public Literal transform(Numeral.IntegerNumeral l) {
        return l;
    }

    public Literal transform(Numeral.FloatNumeral l) {
        return l;
    }

    public Literal transform(StringLiteral l) {
        return l;
    }
}

