/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.runtime;

import org.classdump.luna.ByteString;
import org.classdump.luna.Conversions;
import org.classdump.luna.NoIntegerRepresentationException;
import org.classdump.luna.PlainValueTypeNamer;
import org.classdump.luna.Table;
import org.classdump.luna.runtime.IllegalCoroutineStateException;
import org.classdump.luna.runtime.IllegalOperationAttemptException;

final class Errors {
    private Errors() {
    }

    static NoIntegerRepresentationException noIntegerRepresentation() {
        return new NoIntegerRepresentationException();
    }

    private static String attemptTemplateMessage(String opName, String target) {
        return "attempt to " + opName + " a " + target + " value";
    }

    static IllegalOperationAttemptException illegalArithmeticAttempt(Object a, Object b) {
        ByteString typeName = PlainValueTypeNamer.INSTANCE.typeNameOf(Conversions.numericalValueOf(a) == null ? a : b);
        return new IllegalOperationAttemptException(Errors.attemptTemplateMessage("perform arithmetic on", typeName.toString()));
    }

    static IllegalOperationAttemptException illegalArithmeticAttempt(Object o) {
        ByteString typeName = PlainValueTypeNamer.INSTANCE.typeNameOf(o);
        return new IllegalOperationAttemptException(Errors.attemptTemplateMessage("perform arithmetic on", typeName.toString()));
    }

    static IllegalOperationAttemptException illegalComparisonAttempt(Object a, Object b) {
        ByteString tb;
        ByteString ta = PlainValueTypeNamer.INSTANCE.typeNameOf(a);
        String message = ta.equals(tb = PlainValueTypeNamer.INSTANCE.typeNameOf(b)) ? "attempt to compare two " + ta + " values" : "attempt to compare " + ta + " with " + tb;
        return new IllegalOperationAttemptException(message);
    }

    static IllegalOperationAttemptException illegalCallAttempt(Object o) {
        ByteString typeName = PlainValueTypeNamer.INSTANCE.typeNameOf(o);
        return new IllegalOperationAttemptException(Errors.attemptTemplateMessage("call", typeName.toString()));
    }

    static IllegalOperationAttemptException illegalIndexAttempt(Object table, Object key) {
        Object o = table instanceof Table ? key : table;
        ByteString typeName = PlainValueTypeNamer.INSTANCE.typeNameOf(o);
        return new IllegalOperationAttemptException(Errors.attemptTemplateMessage("index", typeName.toString()));
    }

    static IllegalOperationAttemptException illegalBitwiseOperationAttempt(Object a, Object b) {
        Object nonNumeric;
        Object object = nonNumeric = Conversions.numericalValueOf(a) == null ? a : b;
        if (Conversions.numericalValueOf(nonNumeric) == null) {
            ByteString typeName = PlainValueTypeNamer.INSTANCE.typeNameOf(nonNumeric);
            return new IllegalOperationAttemptException(Errors.attemptTemplateMessage("perform bitwise operation on", typeName.toString()));
        }
        return new IllegalOperationAttemptException(Errors.noIntegerRepresentation());
    }

    static IllegalOperationAttemptException illegalBitwiseOperationAttempt(Object o) {
        if (Conversions.numericalValueOf(o) == null) {
            ByteString typeName = PlainValueTypeNamer.INSTANCE.typeNameOf(o);
            return new IllegalOperationAttemptException(Errors.attemptTemplateMessage("perform bitwise operation on", typeName.toString()));
        }
        return new IllegalOperationAttemptException(Errors.noIntegerRepresentation());
    }

    static IllegalOperationAttemptException illegalGetLengthAttempt(Object o) {
        ByteString typeName = PlainValueTypeNamer.INSTANCE.typeNameOf(o);
        return new IllegalOperationAttemptException("attempt to get length of a " + typeName + " value");
    }

    static IllegalOperationAttemptException illegalConcatenationAttempt(Object a, Object b) {
        ByteString typeName = PlainValueTypeNamer.INSTANCE.typeNameOf(Conversions.stringValueOf(a) == null ? a : b);
        return new IllegalOperationAttemptException(Errors.attemptTemplateMessage("concatenate", typeName.toString()));
    }

    static IllegalCoroutineStateException illegalYieldAttempt() {
        return new IllegalCoroutineStateException("attempt to yield from outside a coroutine");
    }

    static IllegalCoroutineStateException resumeDeadCoroutine() {
        return new IllegalCoroutineStateException("cannot resume dead coroutine");
    }

    static IllegalCoroutineStateException resumeNonSuspendedCoroutine() {
        return new IllegalCoroutineStateException("cannot resume non-suspended coroutine");
    }
}

