/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.util;

import java.util.Arrays;
import java.util.Objects;

public final class ByteVector {
    private final byte[] bytes;

    private ByteVector(byte[] bytes) {
        this.bytes = Objects.requireNonNull(bytes);
    }

    public static ByteVector wrap(byte[] bytes) {
        return new ByteVector(bytes);
    }

    public static ByteVector copyFrom(byte[] bytes) {
        return ByteVector.wrap(Arrays.copyOf(bytes, bytes.length));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteVector that = (ByteVector)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public int size() {
        return this.bytes.length;
    }

    public byte get(int index) {
        return this.bytes[index];
    }

    public byte[] copyToNewArray() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }
}

