/*
 * Decompiled with CFR 0.152.
 */
package org.classdump.luna.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class Cons<T> {
    public final T car;
    public final Cons<T> cdr;

    public Cons(T car, Cons<T> cdr) {
        this.car = Objects.requireNonNull(car);
        this.cdr = cdr;
    }

    public Cons(T car) {
        this(car, null);
    }

    public static <T> Cons<T> fromArray(T[] elems) {
        Cons<T> car = null;
        for (int i = elems.length - 1; i >= 0; --i) {
            car = new Cons<T>(elems[i], car);
        }
        return car;
    }

    @SafeVarargs
    public static <T> Cons<T> fromArgs(T ... elems) {
        return Cons.fromArray(elems);
    }

    public static <T> Cons<T> fromList(List<T> list) {
        return Cons.fromIterator(list.iterator());
    }

    private static <T> Cons<T> fromIterator(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            return new Cons<T>(iterator.next(), Cons.fromIterator(iterator));
        }
        return null;
    }

    public static String toString(Cons<?> cons, String separator) {
        Objects.requireNonNull(separator);
        StringBuilder bld = new StringBuilder();
        while (cons != null) {
            bld.append(cons.car.toString());
            if (cons.cdr != null) {
                bld.append(separator);
            }
            cons = cons.cdr;
        }
        return bld.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cons that = (Cons)o;
        return this.car.equals(that.car) && !(this.cdr == null ? that.cdr != null : !this.cdr.equals(that.cdr));
    }

    public int hashCode() {
        int result = this.car.hashCode();
        result = 31 * result + (this.cdr != null ? this.cdr.hashCode() : 0);
        return result;
    }

    public Cons<T> prepend(Cons<T> prefix) {
        if (prefix == null) {
            return this;
        }
        if (prefix.cdr == null) {
            return new Cons<T>(prefix.car, this);
        }
        return new Cons<T>(prefix.car, this.prepend(prefix.cdr));
    }

    public static int length(Cons<?> cons) {
        int i = 0;
        Cons<Object> p = cons;
        while (p != null) {
            ++i;
            p = p.cdr;
        }
        return i;
    }

    public static <T> T get(Cons<T> cons, int idx) {
        if (idx < 0) {
            return null;
        }
        Cons<T> p = cons;
        while (idx >= 0 && p != null) {
            if (idx == 0) {
                return p.car;
            }
            --idx;
            p = p.cdr;
        }
        return null;
    }

    public static <T> Cons<T> drop(Cons<T> cons, int num) {
        if (num < 0) {
            throw new IllegalArgumentException("num must be non-negative");
        }
        Cons<T> p = cons;
        while (num >= 0 && p != null) {
            if (num == 0) {
                return p;
            }
            --num;
            p = p.cdr;
        }
        return null;
    }

    public static <T> Cons<T> concatenate(Cons<T> left, Cons<T> right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return right.prepend(left);
    }

    public static <T> Iterator<T> newIterator(Cons<T> cons) {
        return new ConsIterator<T>(cons);
    }

    public static <T> Cons<T> flatten(Cons<Cons<T>> original) {
        ArrayList<T> tmp = new ArrayList<T>();
        Cons<Cons<T>> p = original;
        while (p != null) {
            Cons<T> q = (Cons<T>)p.car;
            while (q != null) {
                tmp.add(q.car);
                q = q.cdr;
            }
            p = p.cdr;
        }
        return Cons.fromList(tmp);
    }

    static class ConsIterator<T>
    implements Iterator<T> {
        private Cons<T> p;

        public ConsIterator(Cons<T> p) {
            this.p = p;
        }

        @Override
        public boolean hasNext() {
            return this.p != null;
        }

        @Override
        public T next() {
            if (this.p != null) {
                Object v = this.p.car;
                this.p = this.p.cdr;
                return v;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

