/** 
 * Copyright (c) 2011, Regents of the University of Colorado 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. 
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * Neither the name of the University of Colorado at Boulder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE. 
 */
package org.cleartk.ml;

import java.util.List;

import org.apache.uima.analysis_engine.AnalysisEngineProcessException;

/**
 * <br>
 * Copyright (c) 2011, Regents of the University of Colorado <br>
 * All rights reserved.
 */
public class CleartkProcessingException extends AnalysisEngineProcessException {

  protected static final String DEFAULT_RESOURCE_BUNDLE = "org.cleartk.ml.CleartkExceptions";

  private static final String KEY_PREFIX = CleartkProcessingException.class.getName() + ".";

  private static final long serialVersionUID = 1L;

  public static CleartkProcessingException multipleExceptions(List<? extends Throwable> causes) {
    String key = KEY_PREFIX + "multipleExceptions";
    String message0 = causes.get(0).getMessage();
    return new CleartkProcessingException(
        causes.get(0),
        DEFAULT_RESOURCE_BUNDLE,
        key,
        message0,
        causes.size() - 1);
  }

  public static CleartkProcessingException noInstanceOutcome(List<?> features) {
    String key = KEY_PREFIX + "noInstanceOutcome";
    return new CleartkProcessingException(DEFAULT_RESOURCE_BUNDLE, key, features);
  }

  public static CleartkProcessingException unsupportedOperationSetParameter(
      Throwable cause,
      Object object,
      String methodName,
      String paramName,
      Object paramValue) {
    String key = KEY_PREFIX + "unsupportedOperationSetParameter";
    return new CleartkProcessingException(
        cause,
        DEFAULT_RESOURCE_BUNDLE,
        key,
        object.getClass().getName(),
        methodName,
        paramName,
        paramValue);
  }

  public CleartkProcessingException(
      Throwable cause,
      String resourceBundleName,
      String messageKey,
      Object... arguments) {
    super(resourceBundleName, messageKey, arguments, cause);
  }

  public CleartkProcessingException(
      String resourceBundleName,
      String messageKey,
      Object... arguments) {
    super(resourceBundleName, messageKey, arguments);
  }

  public CleartkProcessingException(Throwable cause) {
    super(cause);
  }
}
