/** 
 * Copyright (c) 2009, Regents of the University of Colorado 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer. 
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution. 
 * Neither the name of the University of Colorado at Boulder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE. 
 */
package org.cleartk.ml.encoder.features;

import java.util.ArrayList;
import java.util.List;

import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.CleartkEncoderException;

/**
 * <br>
 * Copyright (c) 2009, Regents of the University of Colorado <br>
 * All rights reserved.
 * 
 * @author Philipp Wetzler
 */
public class FeatureEncoderChain<ENCODED_TYPE> implements FeatureEncoder<ENCODED_TYPE> {

  private static final long serialVersionUID = -3363875258541749972L;

  public void addEncoder(FeatureEncoder<ENCODED_TYPE> encoder) {
    featureEncoders.add(encoder);
  }

  public List<ENCODED_TYPE> encode(Feature feature) throws CleartkEncoderException {
    for (FeatureEncoder<ENCODED_TYPE> featureEncoder : featureEncoders) {
      if (featureEncoder.encodes(feature))
        return featureEncoder.encode(feature);
    }

    throw CleartkEncoderException.noMatchingEncoder(feature, featureEncoders);
  }

  public boolean encodes(Feature feature) {
    for (FeatureEncoder<ENCODED_TYPE> encoder : featureEncoders)
      if (encoder.encodes(feature))
        return true;

    return false;
  }

  protected List<FeatureEncoder<ENCODED_TYPE>> featureEncoders = new ArrayList<FeatureEncoder<ENCODED_TYPE>>();

}
