/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.util.featurevector;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.cleartk.ml.util.featurevector.FeatureVector;
import org.cleartk.ml.util.featurevector.InvalidFeatureVectorValueException;

public class SparseFeatureVector
extends FeatureVector {
    SortedMap<Integer, Double> values = new TreeMap<Integer, Double>();

    public SparseFeatureVector() {
    }

    public SparseFeatureVector(FeatureVector fv) throws InvalidFeatureVectorValueException {
        this();
        for (FeatureVector.Entry entry : fv) {
            this.set(entry.index, entry.value);
        }
    }

    @Override
    public double get(int index) {
        Double returnValue = (Double)this.values.get(index);
        if (returnValue != null) {
            return returnValue;
        }
        return 0.0;
    }

    @Override
    public java.util.Iterator<FeatureVector.Entry> iterator() {
        return new Iterator(this.values);
    }

    @Override
    public void set(int index, double value) throws InvalidFeatureVectorValueException {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new InvalidFeatureVectorValueException(index, value);
        }
        if (value != 0.0) {
            this.values.put(index, value);
        } else if (this.values.containsKey(index)) {
            this.values.remove(index);
        }
    }

    @Override
    public double innerProduct(FeatureVector other) {
        double result = 0.0;
        for (FeatureVector.Entry entry : this) {
            result += entry.value * other.get(entry.index);
        }
        return result;
    }

    class Iterator
    implements java.util.Iterator<FeatureVector.Entry> {
        java.util.Iterator<Map.Entry<Integer, Double>> subIterator;
        SortedMap<Integer, Double> itValues;

        Iterator(SortedMap<Integer, Double> values) {
            this.itValues = values;
            this.subIterator = values.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.subIterator.hasNext();
        }

        @Override
        public FeatureVector.Entry next() {
            Map.Entry<Integer, Double> nextEntry = this.subIterator.next();
            int key = nextEntry.getKey();
            double value = nextEntry.getValue();
            return new FeatureVector.Entry(key, value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

