/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.dynamic.loading.MultipleParentClassLoader;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.UimaContextHolder;

public class ClassLookup {
    private ClassLookup() {
    }

    public static <T> Class<T> lookupClass(String aClass) throws ClassNotFoundException {
        List<ClassLoader> classLoaders = ClassLookup.collectClassLoaders();
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("Could not find class [" + aClass + "] in any of these classloaders:\n");
        for (ClassLoader cl : classLoaders) {
            try {
                return cl.loadClass(aClass);
            }
            catch (ClassNotFoundException e) {
                errorMessage.append("- " + cl + "\n");
            }
        }
        throw new ClassNotFoundException(errorMessage.toString());
    }

    private static List<ClassLoader> collectClassLoaders() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        UimaContext ctx = UimaContextHolder.getContext();
        if (ctx != null) {
            UimaContextAdmin ctxAdmin = (UimaContextAdmin)ctx;
            classLoaders.add(ctxAdmin.getResourceManager().getExtensionClassLoader());
        }
        classLoaders.add(Thread.currentThread().getContextClassLoader());
        classLoaders.add(ClassLookup.class.getClassLoader());
        classLoaders.removeIf(cl -> cl == null);
        return classLoaders;
    }

    public static ObjectInputStream streamObjects(InputStream aIs) throws StreamCorruptedException, IOException {
        return new ClassLoaderObjectInputStream((ClassLoader)new MultipleParentClassLoader(ClassLookup.collectClassLoaders()), aIs);
    }
}

