/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util;

import java.util.HashMap;
import org.apache.commons.lang3.SystemUtils;

public class PlatformDetection {
    private String os;
    private String arch;
    public static String OS_WINDOWS = "windows";
    public static String OS_OSX = "osx";
    public static String OS_SOLARIS = "solaris";
    public static String OS_LINUX = "linux";
    public static String ARCH_PPC = "ppc";
    public static String ARCH_X86_32 = "x86_32";
    public static String ARCH_X86_64 = "x86_64";
    public static String ARCH_ARM_64 = "aarch64";

    public PlatformDetection() {
        if (SystemUtils.IS_OS_WINDOWS) {
            this.os = OS_WINDOWS;
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            this.os = OS_OSX;
        } else if (SystemUtils.IS_OS_SOLARIS) {
            this.os = OS_SOLARIS;
        } else if (SystemUtils.IS_OS_LINUX) {
            this.os = OS_LINUX;
        } else {
            throw new IllegalArgumentException("Unknown operating system " + SystemUtils.OS_NAME);
        }
        HashMap<String, String> archMap = new HashMap<String, String>();
        archMap.put("x86", ARCH_X86_32);
        archMap.put("i386", ARCH_X86_32);
        archMap.put("i486", ARCH_X86_32);
        archMap.put("i586", ARCH_X86_32);
        archMap.put("i686", ARCH_X86_32);
        archMap.put("x86_64", ARCH_X86_64);
        archMap.put("amd64", ARCH_X86_64);
        archMap.put("powerpc", ARCH_PPC);
        archMap.put("aarch64", ARCH_ARM_64);
        this.arch = (String)archMap.get(SystemUtils.OS_ARCH);
        if (this.arch == null) {
            throw new IllegalArgumentException("Unknown architecture " + SystemUtils.OS_ARCH);
        }
    }

    public String getOs() {
        return this.os;
    }

    public String getArch() {
        return this.arch;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String toString() {
        return this.os + "_" + this.arch;
    }

    public String getExecutableSuffix() {
        if (this.getOs().equals(OS_WINDOWS)) {
            return ".exe";
        }
        return "";
    }
}

