/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.ae;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.component.ViewCreatorAnnotator;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ViewUriUtil;

public class UriToDocumentTextAnnotator
extends JCasAnnotator_ImplBase {
    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(UriToDocumentTextAnnotator.class, (Object[])new Object[0]);
    }

    public static AnalysisEngineDescription getDescriptionForView(String targetViewName) throws ResourceInitializationException {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(AnalysisEngineFactory.createEngineDescription(ViewCreatorAnnotator.class, (Object[])new Object[]{"viewName", targetViewName}), new String[0]);
        builder.add(UriToDocumentTextAnnotator.getDescription(), new String[]{"_InitialView", targetViewName});
        return builder.createAggregateDescription();
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        URI uri = ViewUriUtil.getURI(jCas);
        try (InputStreamReader reader = new InputStreamReader(uri.toURL().openStream());){
            String content = CharStreams.toString((Readable)reader);
            jCas.setSofaDataString(content, "text/plain");
        }
        catch (MalformedURLException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

