/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.ae.linewriter;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.initializable.InitializableFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ClassLookup;
import org.cleartk.util.CleartkInitializationException;
import org.cleartk.util.ReflectionUtil;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.ae.linewriter.AnnotationWriter;
import org.cleartk.util.ae.linewriter.BlockWriter;

public class LineWriter<ANNOTATION_TYPE extends Annotation, BLOCK_TYPE extends Annotation>
extends JCasAnnotator_ImplBase {
    private static final String OUTPUT_DIRECTORY_NAME_DESCRIPTION = "takes a path to directory into which output files will be written. If no value is given for this parameter, then the parameter 'outputFileName' is required. If a value is given, then one file for each document/JCas will be created in the output directory provided.   The name of each file will be given by the value returned by ViewURIUtil.getURI(jCas). If a value for both 'outputDirectoryName' and ' outputFileName'  is given, then an exception will be thrown. Example values that could be provided might look like: \n\n\t/mydata/uima-output/\n\tC:/Documents and Settings/User/My Documents/workspace/My Project/data/experiment/output\n";
    public static final String PARAM_OUTPUT_DIRECTORY_NAME = "outputDirectoryName";
    @ConfigurationParameter(description="takes a path to directory into which output files will be written. If no value is given for this parameter, then the parameter 'outputFileName' is required. If a value is given, then one file for each document/JCas will be created in the output directory provided.   The name of each file will be given by the value returned by ViewURIUtil.getURI(jCas). If a value for both 'outputDirectoryName' and ' outputFileName'  is given, then an exception will be thrown. Example values that could be provided might look like: \n\n\t/mydata/uima-output/\n\tC:/Documents and Settings/User/My Documents/workspace/My Project/data/experiment/output\n", name="outputDirectoryName", mandatory=false)
    private String outputDirectoryName;
    private static final String FILE_SUFFIX_DESCRIPTION = "provides a file name suffix for each file generated by this writer.  If there is no value given for the parameter 'outputDirectoryName', then this parameter is ignored. If 'outputDirectoryName' is given a value, then the generated files will be named by the document ids and the suffix provided by this  parameter. If no value for this parameter is given, then the files will be named the same as the document id. Example values that could be provided might include: \n\n.txt\n.tokens\n.annotations.txt";
    public static final String PARAM_FILE_SUFFIX = "fileSuffix";
    @ConfigurationParameter(description="provides a file name suffix for each file generated by this writer.  If there is no value given for the parameter 'outputDirectoryName', then this parameter is ignored. If 'outputDirectoryName' is given a value, then the generated files will be named by the document ids and the suffix provided by this  parameter. If no value for this parameter is given, then the files will be named the same as the document id. Example values that could be provided might include: \n\n.txt\n.tokens\n.annotations.txt", name="fileSuffix", mandatory=false)
    private String fileSuffix;
    private static final String OUTPUT_FILE_NAME_DESCRIPTION = "takes a file name to write results to.  If no value is given for this parameter, then the parameter 'outputDirectoryName' is required.  If a value is given, then one file for all documents will be created in the output directory provided. If a value for both 'outputDirectoryName' and 'outputFileName' is given, then an exception will be thrown. Example values that could be provided might look like: \n\n/mydata/uima-output/annotations.txt\nC:\\Documents and Settings\\User\\My Documents\\workspace\\My Project\\data\\experiment\\output\\output.annotations\n";
    public static final String PARAM_OUTPUT_FILE_NAME = "outputFileName";
    @ConfigurationParameter(description="takes a file name to write results to.  If no value is given for this parameter, then the parameter 'outputDirectoryName' is required.  If a value is given, then one file for all documents will be created in the output directory provided. If a value for both 'outputDirectoryName' and 'outputFileName' is given, then an exception will be thrown. Example values that could be provided might look like: \n\n/mydata/uima-output/annotations.txt\nC:\\Documents and Settings\\User\\My Documents\\workspace\\My Project\\data\\experiment\\output\\output.annotations\n", name="outputFileName", mandatory=false)
    private String outputFileName;
    private static final String OUTPUT_ANNOTATION_CLASS_NAME_DESCRIPTION = "takes the name of the annotation class of the annotations that are to be written out. The annotation class must be a subclass of org.apache.uima.jcas.tcas.Annotation. The manner in which annotations are written out is determined by the AnnotationWriter as described below. The AnnotationWriter interface is generically typed. The class specified by this parameter must be the same as or a subclass of the type specified by the implementation of AnnotationWriter. Example values that could be provided might include:\n\norg.apache.uima.jcas.tcas.Annotation (default)\norg.cleartk.type.Token\norg.cleartk.type.Sentence\ncom.yourcompany.yourpackage.YourType";
    public static final String PARAM_OUTPUT_ANNOTATION_CLASS_NAME = "outputAnnotationClassName";
    @ConfigurationParameter(name="outputAnnotationClassName", mandatory=true, description="takes the name of the annotation class of the annotations that are to be written out. The annotation class must be a subclass of org.apache.uima.jcas.tcas.Annotation. The manner in which annotations are written out is determined by the AnnotationWriter as described below. The AnnotationWriter interface is generically typed. The class specified by this parameter must be the same as or a subclass of the type specified by the implementation of AnnotationWriter. Example values that could be provided might include:\n\norg.apache.uima.jcas.tcas.Annotation (default)\norg.cleartk.type.Token\norg.cleartk.type.Sentence\ncom.yourcompany.yourpackage.YourType", defaultValue={"org.apache.uima.jcas.tcas.Annotation"})
    private static String outputAnnotationClassName;
    private static final String ANNOTATION_WRITER_CLASS_NAME_DESCRIPTION = "provides the class name of a class that extends org.cleartk.util.linewriter.AnnotationWriter. The AnnotationWriter determines how annotations will be written. For example, CoveredTextAnnotationWriter simply writes out the covered text of an annotation. Example values that could be provided might include:\n\norg.cleartk.util.linewriter.annotation.CoveredTextAnnotationWriter (default)\norg.cleartk.util.linewriter.annotation.TokenPOSWriter\n";
    public static final String PARAM_ANNOTATION_WRITER_CLASS_NAME = "annotationWriterClassName";
    @ConfigurationParameter(name="annotationWriterClassName", mandatory=true, description="provides the class name of a class that extends org.cleartk.util.linewriter.AnnotationWriter. The AnnotationWriter determines how annotations will be written. For example, CoveredTextAnnotationWriter simply writes out the covered text of an annotation. Example values that could be provided might include:\n\norg.cleartk.util.linewriter.annotation.CoveredTextAnnotationWriter (default)\norg.cleartk.util.linewriter.annotation.TokenPOSWriter\n", defaultValue={"org.cleartk.util.ae.linewriter.annotation.CoveredTextAnnotationWriter"})
    private String annotationWriterClassName;
    private static final String BLOCK_ANNOTATION_CLASS_NAME_DESCRIPTION = "Takes the name of an annotation class that determines a 'block' of lines in the resulting output file(s). Each 'block' of lines is separated by some text (such as a newline) as determined by the BlockWriter specified as described below. If, for example, the value of 'outputAnnotationClassName' is 'org.cleartk.type.Token' and the value for 'blockAnnotationClassName' is 'org.cleartk.type.Sentence' and the value for 'blockWriterClassName'  is 'org.cleartk.util.linewriter.block.BlankLineBlockWriter' (the default), then the tokens in each sentence will be written out one per line with a blank line between the last token of a sentence and the first token of the following sentence. Note that setting this parameter may limit the number of annotations that are written out if, for example, not all tokens are found inside sentences.  If no value is given, then there will be no blank lines in the resulting file (assuming the AnnotationWriter does not produce a blank line). If you want there to be a blank line between each document (assuming 'outputFileName'  is given a parameter), then this parameter should be given the value 'org.apache.uima.jcas.tcas.DocumentAnnotation'. Example values that could be provided might include: \n\norg.cleartk.type.Sentence\norg.apache.uima.jcas.tcas.DocumentAnnotation\ncom.yourcompany.yourpackage.YourType\n";
    public static final String PARAM_BLOCK_ANNOTATION_CLASS_NAME = "blockAnnotationClassName";
    @ConfigurationParameter(description="Takes the name of an annotation class that determines a 'block' of lines in the resulting output file(s). Each 'block' of lines is separated by some text (such as a newline) as determined by the BlockWriter specified as described below. If, for example, the value of 'outputAnnotationClassName' is 'org.cleartk.type.Token' and the value for 'blockAnnotationClassName' is 'org.cleartk.type.Sentence' and the value for 'blockWriterClassName'  is 'org.cleartk.util.linewriter.block.BlankLineBlockWriter' (the default), then the tokens in each sentence will be written out one per line with a blank line between the last token of a sentence and the first token of the following sentence. Note that setting this parameter may limit the number of annotations that are written out if, for example, not all tokens are found inside sentences.  If no value is given, then there will be no blank lines in the resulting file (assuming the AnnotationWriter does not produce a blank line). If you want there to be a blank line between each document (assuming 'outputFileName'  is given a parameter), then this parameter should be given the value 'org.apache.uima.jcas.tcas.DocumentAnnotation'. Example values that could be provided might include: \n\norg.cleartk.type.Sentence\norg.apache.uima.jcas.tcas.DocumentAnnotation\ncom.yourcompany.yourpackage.YourType\n", name="blockAnnotationClassName", mandatory=false)
    private String blockAnnotationClassName;
    private static final String BLOCK_WRITER_CLASS_NAME_DESCRIPTION = "Provides  the class name of a class that extends org.cleartk.util.linewriter.BlockWriter. The BlockWriter determines how blocks of annotations will be delimited. For example, org.cleartk.util.linewriter.block.BlankLineBlockWriter simply writes out a blank line between each block of annotations.  Example values that could be provided might include: \n\norg.cleartk.util.linewriter.block.BlankLineBlockWriter\norg.cleartk.util.linewriter.block.DocumentIdBlockWriter\n";
    public static final String PARAM_BLOCK_WRITER_CLASS_NAME = "blockWriterClassName";
    @ConfigurationParameter(name="blockWriterClassName", description="Provides  the class name of a class that extends org.cleartk.util.linewriter.BlockWriter. The BlockWriter determines how blocks of annotations will be delimited. For example, org.cleartk.util.linewriter.block.BlankLineBlockWriter simply writes out a blank line between each block of annotations.  Example values that could be provided might include: \n\norg.cleartk.util.linewriter.block.BlankLineBlockWriter\norg.cleartk.util.linewriter.block.DocumentIdBlockWriter\n", mandatory=false, defaultValue={"org.cleartk.util.ae.linewriter.block.BlankLineBlockWriter"})
    private String blockWriterClassName;
    private File outputDirectory;
    private File outputFile;
    private Class<? extends Annotation> outputAnnotationClass;
    private org.apache.uima.cas.Type outputAnnotationType;
    private Class<? extends Annotation> blockAnnotationClass;
    private org.apache.uima.cas.Type blockAnnotationType;
    boolean blockOnDocument = false;
    AnnotationWriter<ANNOTATION_TYPE> annotationWriter;
    BlockWriter<BLOCK_TYPE> blockWriter;
    PrintStream out;
    private boolean typesInitialized = false;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        try {
            super.initialize(context);
            if (this.outputDirectoryName == null && this.outputFileName == null || this.outputDirectoryName != null && this.outputFileName != null) {
                throw CleartkInitializationException.notExactlyOneParameterSet(PARAM_OUTPUT_DIRECTORY_NAME, this.outputDirectoryName, PARAM_OUTPUT_FILE_NAME, this.outputFileName);
            }
            if (this.outputDirectoryName != null) {
                this.outputDirectory = new File(this.outputDirectoryName);
                if (!this.outputDirectory.exists()) {
                    this.outputDirectory.mkdirs();
                }
            }
            if (this.outputFileName != null) {
                this.outputFile = new File(this.outputFileName);
                if (!this.outputFile.getParentFile().exists()) {
                    this.outputFile.getParentFile().mkdirs();
                }
                this.out = new PrintStream(this.outputFile);
            }
            this.outputAnnotationClass = InitializableFactory.getClass((String)outputAnnotationClassName, Annotation.class);
            Class annotationWriterClass = (Class)ReflectionUtil.uncheckedCast(ClassLookup.lookupClass(this.annotationWriterClassName).asSubclass(AnnotationWriter.class));
            this.annotationWriter = (AnnotationWriter)InitializableFactory.create((UimaContext)context, (String)this.annotationWriterClassName, (Class)annotationWriterClass);
            Type annotationType = ReflectionUtil.getTypeArgument(AnnotationWriter.class, "ANNOTATION_TYPE", this.annotationWriter);
            if (!ReflectionUtil.isAssignableFrom(annotationType, this.outputAnnotationClass)) {
                throw CleartkInitializationException.incompatibleTypeParameterAndType(this.annotationWriter, "ANNOTATION_TYPE", annotationType, this.outputAnnotationClass);
            }
            if (this.blockAnnotationClassName != null) {
                Class blockWriterClass = (Class)ReflectionUtil.uncheckedCast(ClassLookup.lookupClass(this.blockWriterClassName).asSubclass(BlockWriter.class));
                this.blockWriter = (BlockWriter)InitializableFactory.create((UimaContext)context, (String)this.blockWriterClassName, (Class)blockWriterClass);
                if (this.blockAnnotationClassName.equals("org.apache.uima.jcas.tcas.DocumentAnnotation")) {
                    this.blockOnDocument = true;
                } else {
                    this.blockAnnotationClass = ClassLookup.lookupClass(this.blockAnnotationClassName).asSubclass(Annotation.class);
                    Type blockType = ReflectionUtil.getTypeArgument(BlockWriter.class, "BLOCK_TYPE", this.blockWriter);
                    if (!ReflectionUtil.isAssignableFrom(blockType, this.blockAnnotationClass)) {
                        throw CleartkInitializationException.incompatibleTypeParameterAndType(this.blockWriter, "BLOCK_TYPE", blockType, this.blockAnnotationClass);
                    }
                }
            }
            if (this.fileSuffix == null) {
                this.fileSuffix = "";
            } else if (!this.fileSuffix.startsWith(".")) {
                this.fileSuffix = "." + this.fileSuffix;
            }
        }
        catch (Exception e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    private void initializeTypes(JCas jCas) throws AnalysisEngineProcessException {
        try {
            this.outputAnnotationType = JCasUtil.getType((JCas)jCas, this.outputAnnotationClass);
            if (this.blockAnnotationClass != null) {
                this.blockAnnotationType = JCasUtil.getType((JCas)jCas, this.blockAnnotationClass);
            }
        }
        catch (Exception e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        this.typesInitialized = true;
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (!this.typesInitialized) {
            this.initializeTypes(jCas);
        }
        try {
            Object documentAnnotation;
            if (this.outputDirectory != null) {
                String id = new File(ViewUriUtil.getURI(jCas)).getName();
                while (id.endsWith(".")) {
                    id = id.substring(0, id.length() - 1);
                }
                this.out = new PrintStream(new File(this.outputDirectory, id + this.fileSuffix));
            }
            if (this.blockOnDocument) {
                documentAnnotation = (Annotation)jCas.getDocumentAnnotationFs();
                this.out.print(this.blockWriter.writeBlock(jCas, documentAnnotation));
                for (Annotation outputAnnotation : jCas.getAnnotationIndex(this.outputAnnotationType)) {
                    this.out.println(this.annotationWriter.writeAnnotation(jCas, outputAnnotation));
                }
            } else if (this.blockAnnotationType != null) {
                documentAnnotation = JCasUtil.select((JCas)jCas, this.blockAnnotationClass).iterator();
                while (documentAnnotation.hasNext()) {
                    Annotation block;
                    Annotation blockAnnotation = block = (Annotation)documentAnnotation.next();
                    this.out.print(this.blockWriter.writeBlock(jCas, blockAnnotation));
                    Iterator iterator = JCasUtil.selectCovered(this.outputAnnotationClass, (AnnotationFS)blockAnnotation).iterator();
                    while (iterator.hasNext()) {
                        Annotation output;
                        Annotation outputAnnotation = output = (Annotation)iterator.next();
                        this.out.println(this.annotationWriter.writeAnnotation(jCas, outputAnnotation));
                    }
                }
            } else {
                for (Annotation outputAnnotation : jCas.getAnnotationIndex(this.outputAnnotationType)) {
                    this.out.println(this.annotationWriter.writeAnnotation(jCas, outputAnnotation));
                }
            }
            if (this.outputDirectory != null) {
                this.out.flush();
                this.out.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new AnalysisEngineProcessException((Throwable)fnfe);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        if (this.outputFile != null) {
            this.out.flush();
            this.out.close();
        }
        super.collectionProcessComplete();
    }
}

