/*
 * Decompiled with CFR 0.152.
 */
package clojure.tools.nrepl;

import clojure.lang.AFn;
import clojure.lang.Delay;
import clojure.lang.IFn;
import clojure.lang.Keyword;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;
import clojure.tools.nrepl.SafeFn;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Connection {
    private static SafeFn connect;
    private static SafeFn readResponseValue;
    private static SafeFn combineResponses;
    private static SafeFn responseSeq;
    private static SafeFn evalResponse;
    private static SafeFn map;
    private static SafeFn readString;
    public final Map<Keyword, IFn> conn;
    private final SafeFn send;
    private final SafeFn close;
    public final String host;
    public final int port;

    public Connection(String host, int port) throws Exception {
        this.host = host;
        this.port = port;
        this.conn = (Map)connect.invoke(host, port);
        this.send = SafeFn.wrap(this.conn.get(Keyword.intern((String)"send")));
        this.close = SafeFn.wrap(this.conn.get(Keyword.intern((String)"close")));
    }

    public Response send(String code) {
        return new Response(SafeFn.wrap((IFn)this.send.sInvoke(code)));
    }

    public void close() {
        this.close.sInvoke();
    }

    static {
        Var initClojure = RT.OUT;
        try {
            RT.var((String)"clojure.core", (String)"require").invoke((Object)Symbol.intern((String)"clojure.tools.nrepl"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        connect = SafeFn.find("clojure.tools.nrepl", "connect");
        readResponseValue = SafeFn.find("clojure.tools.nrepl", "read-response-value");
        combineResponses = SafeFn.find("clojure.tools.nrepl", "combine-responses");
        responseSeq = SafeFn.find("clojure.tools.nrepl", "response-seq");
        evalResponse = SafeFn.find("clojure.tools.nrepl", "eval-response");
        map = SafeFn.find("clojure.core", "map");
        readString = SafeFn.find("clojure.core", "read-string");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Response {
        public final SafeFn responseFn;
        private final Delay combinedResponse;

        private Response(SafeFn responseFn) {
            this.responseFn = responseFn;
            this.combinedResponse = new Delay((IFn)new AFn(){

                public Object invoke() throws Exception {
                    return combineResponses.invoke(responseSeq.invoke(Response.this.responseFn));
                }
            });
        }

        public Map<Keyword, Object> combinedResponse() {
            try {
                return (Map)this.combinedResponse.deref();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Set<String> statuses() {
            try {
                return (Set)this.combinedResponse().get(Keyword.intern((String)"status"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<Object> values() {
            return (List)map.sInvoke(readString, this.combinedResponse().get(Keyword.intern((String)"value")));
        }
    }
}

