/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.domain;

import java.util.Map;
import org.cloudfoundry.client.lib.util.CloudUtil;

public class CloudInfo {
    private Limits limits;
    private Usage usage;
    private String name;
    private String support;
    private String build;
    private String version;
    private String user;
    private String description;
    private String authorizationEndpoint;
    private boolean allowDebug;
    private String loggregatorEndpoint;

    public CloudInfo(Map<String, Object> infoMap) {
        Number iVersion;
        this.name = CloudUtil.parse(String.class, infoMap.get("name"));
        this.support = CloudUtil.parse(String.class, infoMap.get("support"));
        this.build = CloudUtil.parse(String.class, infoMap.get("build"));
        this.version = CloudUtil.parse(String.class, infoMap.get("version"));
        if (this.version == null && (iVersion = CloudUtil.parse(Number.class, infoMap.get("version"))) != null) {
            this.version = iVersion.toString();
        }
        this.user = CloudUtil.parse(String.class, infoMap.get("user"));
        this.description = CloudUtil.parse(String.class, infoMap.get("description"));
        this.authorizationEndpoint = CloudUtil.parse(String.class, infoMap.get("authorization_endpoint"));
        this.loggregatorEndpoint = CloudUtil.parse(String.class, infoMap.get("logging_endpoint"));
        Object allowDebugValue = infoMap.get("allow_debug");
        this.allowDebug = allowDebugValue != null ? CloudUtil.parse(Boolean.class, allowDebugValue) : false;
        Map limitsMap = CloudUtil.parse(Map.class, infoMap.get("limits"));
        this.limits = limitsMap != null ? new Limits(limitsMap) : new Limits();
        Map usageMap = CloudUtil.parse(Map.class, infoMap.get("usage"));
        this.usage = usageMap != null ? new Usage(usageMap) : new Usage();
    }

    public CloudInfo(String name, String support, String authorizationEndpoint, String build, String version, String user, String description, Limits limits, Usage usage, boolean allowDebug, String loggregatorEndpoint) {
        this.name = name;
        this.support = support;
        this.authorizationEndpoint = authorizationEndpoint;
        this.loggregatorEndpoint = loggregatorEndpoint;
        this.build = build;
        this.version = version;
        this.user = user;
        this.description = description;
        this.limits = limits;
        this.usage = usage;
        this.allowDebug = allowDebug;
    }

    public Limits getLimits() {
        return this.limits;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public String getName() {
        return this.name;
    }

    public String getSupport() {
        return this.support;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public String getLoggregatorEndpoint() {
        return this.loggregatorEndpoint;
    }

    public String getBuild() {
        return this.build;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUser() {
        return this.user;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean getAllowDebug() {
        return this.allowDebug;
    }

    public static class Usage {
        private int apps;
        private int totalMemory;
        private int urisPerApp;
        private int services;

        public Usage(Map<String, Object> data) {
            if (data != null && !data.isEmpty()) {
                this.apps = CloudUtil.parse(Integer.class, data.get("apps"));
                this.totalMemory = CloudUtil.parse(Integer.class, data.get("memory"));
                this.urisPerApp = CloudUtil.parse(Integer.class, data.get("app_uris"));
                this.services = CloudUtil.parse(Integer.class, data.get("services"));
            }
        }

        Usage() {
            this.apps = Integer.MAX_VALUE;
            this.totalMemory = Integer.MAX_VALUE;
            this.urisPerApp = Integer.MAX_VALUE;
            this.services = Integer.MAX_VALUE;
        }

        public int getApps() {
            return this.apps;
        }

        public int getTotalMemory() {
            return this.totalMemory;
        }

        public int getUrisPerApp() {
            return this.urisPerApp;
        }

        public int getServices() {
            return this.services;
        }
    }

    public static class Limits {
        private int maxApps;
        private int maxTotalMemory;
        private int maxUrisPerApp;
        private int maxServices;

        public Limits(Map<String, Object> limitMap) {
            this.maxApps = CloudUtil.parse(Integer.class, limitMap.get("apps"));
            this.maxTotalMemory = CloudUtil.parse(Integer.class, limitMap.get("memory"));
            this.maxUrisPerApp = CloudUtil.parse(Integer.class, limitMap.get("app_uris"));
            this.maxServices = CloudUtil.parse(Integer.class, limitMap.get("services"));
        }

        Limits() {
            this.maxApps = Integer.MAX_VALUE;
            this.maxTotalMemory = Integer.MAX_VALUE;
            this.maxUrisPerApp = Integer.MAX_VALUE;
            this.maxServices = Integer.MAX_VALUE;
        }

        public int getMaxApps() {
            return this.maxApps;
        }

        public int getMaxTotalMemory() {
            return this.maxTotalMemory;
        }

        public int getMaxUrisPerApp() {
            return this.maxUrisPerApp;
        }

        public int getMaxServices() {
            return this.maxServices;
        }
    }
}

