/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.rest;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.cloudfoundry.client.lib.domain.UploadApplicationPayload;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.util.FileCopyUtils;

public class UploadApplicationPayloadHttpMessageConverter
implements HttpMessageConverter<UploadApplicationPayload> {
    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return UploadApplicationPayload.class.isAssignableFrom(clazz);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Collections.singletonList(MediaType.ALL);
    }

    public UploadApplicationPayload read(Class<? extends UploadApplicationPayload> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException();
    }

    public void write(UploadApplicationPayload t, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.setOutputContentType(contentType, outputMessage);
        FileCopyUtils.copy((InputStream)t.getInputStream(), (OutputStream)outputMessage.getBody());
        outputMessage.getBody().flush();
        this.writeApplicationZipToFile(t.getInputStream());
    }

    private void setOutputContentType(MediaType contentType, HttpOutputMessage outputMessage) {
        HttpHeaders headers = outputMessage.getHeaders();
        if (contentType == null || contentType.isWildcardType() || contentType.isWildcardSubtype()) {
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        if (contentType != null) {
            headers.setContentType(contentType);
        }
    }

    private void writeApplicationZipToFile(InputStream inputStream) {
        String uploadFilePath = System.getenv("CF_APP_UPLOAD_FILE");
        if (uploadFilePath != null) {
            try {
                File outputFile = new File(uploadFilePath);
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
                FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                outputStream.close();
            }
            catch (IOException e) {
                System.err.println("Error writing application upload to file: " + e);
            }
        }
    }
}

