/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.client.lib.domain.CloudResource;
import org.cloudfoundry.client.lib.org.codehaus.jackson.JsonParseException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.JsonMappingException;
import org.cloudfoundry.client.lib.org.codehaus.jackson.map.ObjectMapper;
import org.cloudfoundry.client.lib.org.codehaus.jackson.type.TypeReference;
import org.springframework.http.MediaType;

public class JsonUtil {
    protected static final Log logger = LogFactory.getLog(JsonUtil.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    public static final MediaType JSON_MEDIA_TYPE = new MediaType(MediaType.APPLICATION_JSON.getType(), MediaType.APPLICATION_JSON.getSubtype(), Charset.forName("UTF-8"));

    public static Map<String, Object> convertJsonToMap(String json) {
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (json != null) {
            try {
                retMap = (Map)mapper.readValue(json, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                logger.warn((Object)("Error while reading Java Map from JSON response: " + json), (Throwable)e);
            }
        }
        return retMap;
    }

    public static List<String> convertJsonToList(String json) {
        List<String> retList = new ArrayList<String>();
        if (json != null) {
            try {
                retList = (List)mapper.readValue(json, (TypeReference)new TypeReference<List<String>>(){});
            }
            catch (IOException e) {
                logger.warn((Object)("Error while reading Java List from JSON response: " + json), (Throwable)e);
            }
        }
        return retList;
    }

    public static List<CloudResource> convertJsonToCloudResourceList(String json) {
        List<CloudResource> retList = new ArrayList<CloudResource>();
        if (json != null) {
            try {
                retList = (List)mapper.readValue(json, (TypeReference)new TypeReference<List<CloudResource>>(){});
            }
            catch (IOException e) {
                logger.warn((Object)("Error while reading Java List from JSON response: " + json), (Throwable)e);
            }
        }
        return retList;
    }

    public static String convertToJson(Object value) {
        if (mapper.canSerialize(value.getClass())) {
            try {
                return mapper.writeValueAsString(value);
            }
            catch (IOException e) {
                logger.warn((Object)("Error while serializing " + value + " to JSON"), (Throwable)e);
                return null;
            }
        }
        throw new IllegalArgumentException("Value of type " + value.getClass().getName() + " can not be serialized to JSON.");
    }

    public static List<Map<String, Object>> convertToJsonList(InputStream jsonInputStream) {
        try {
            return mapper.readValue(jsonInputStream, List.class);
        }
        catch (JsonParseException e) {
            logger.error((Object)"Unable to parse JSON from InputStream", (Throwable)e);
            throw new IllegalArgumentException("Unable to parse JSON from InputStream", e);
        }
        catch (JsonMappingException e) {
            logger.error((Object)"Unable to parse JSON from InputStream", (Throwable)e);
            throw new IllegalArgumentException("Unable to parse JSON from InputStream", e);
        }
        catch (IOException e) {
            logger.error((Object)"Unable to process InputStream", (Throwable)e);
            throw new IllegalArgumentException("Unable to parse JSON from InputStream", e);
        }
    }
}

