/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.lib.util;

import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.cloudfoundry.client.lib.HttpProxyConfiguration;
import org.cloudfoundry.client.lib.oauth2.OauthClient;
import org.cloudfoundry.client.lib.rest.CloudControllerResponseErrorHandler;
import org.cloudfoundry.client.lib.rest.CloudFoundryFormHttpMessageConverter;
import org.cloudfoundry.client.lib.rest.LoggingRestTemplate;
import org.cloudfoundry.client.lib.rest.LoggregatorHttpMessageConverter;
import org.cloudfoundry.client.lib.rest.UploadApplicationPayloadHttpMessageConverter;
import org.cloudfoundry.client.lib.util.JsonUtil;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class RestUtil {
    public RestTemplate createRestTemplate(HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
        LoggingRestTemplate restTemplate = new LoggingRestTemplate();
        restTemplate.setRequestFactory(this.createRequestFactory(httpProxyConfiguration, trustSelfSignedCerts));
        restTemplate.setErrorHandler((ResponseErrorHandler)new CloudControllerResponseErrorHandler());
        restTemplate.setMessageConverters(this.getHttpMessageConverters());
        return restTemplate;
    }

    public ClientHttpRequestFactory createRequestFactory(HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().useSystemProperties();
        if (trustSelfSignedCerts) {
            httpClientBuilder.setSslcontext(this.buildSslContext());
            httpClientBuilder.setHostnameVerifier(SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        }
        if (httpProxyConfiguration != null) {
            HttpHost proxy = new HttpHost(httpProxyConfiguration.getProxyHost(), httpProxyConfiguration.getProxyPort());
            httpClientBuilder.setProxy(proxy);
            if (httpProxyConfiguration.isAuthRequired()) {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(httpProxyConfiguration.getProxyHost(), httpProxyConfiguration.getProxyPort()), (Credentials)new UsernamePasswordCredentials(httpProxyConfiguration.getUsername(), httpProxyConfiguration.getPassword()));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
            httpClientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        return requestFactory;
    }

    public OauthClient createOauthClient(URL authorizationUrl, HttpProxyConfiguration httpProxyConfiguration, boolean trustSelfSignedCerts) {
        return new OauthClient(authorizationUrl, this.createRestTemplate(httpProxyConfiguration, trustSelfSignedCerts));
    }

    private SSLContext buildSslContext() {
        try {
            return new SSLContextBuilder().useSSL().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException("An error occurred setting up the SSLContext", gse);
        }
    }

    private List<HttpMessageConverter<?>> getHttpMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        messageConverters.add((HttpMessageConverter<?>)new ByteArrayHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new StringHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        messageConverters.add(new UploadApplicationPayloadHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)this.getFormHttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter());
        messageConverters.add((HttpMessageConverter<?>)new LoggregatorHttpMessageConverter());
        return messageConverters;
    }

    private FormHttpMessageConverter getFormHttpMessageConverter() {
        CloudFoundryFormHttpMessageConverter formPartsMessageConverter = new CloudFoundryFormHttpMessageConverter();
        formPartsMessageConverter.setPartConverters(this.getFormPartsMessageConverters());
        return formPartsMessageConverter;
    }

    private List<HttpMessageConverter<?>> getFormPartsMessageConverters() {
        ArrayList partConverters = new ArrayList();
        StringHttpMessageConverter stringConverter = new StringHttpMessageConverter();
        stringConverter.setSupportedMediaTypes(Collections.singletonList(JsonUtil.JSON_MEDIA_TYPE));
        stringConverter.setWriteAcceptCharset(false);
        partConverters.add((HttpMessageConverter<?>)stringConverter);
        partConverters.add((HttpMessageConverter<?>)new ResourceHttpMessageConverter());
        partConverters.add(new UploadApplicationPayloadHttpMessageConverter());
        return partConverters;
    }
}

