package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.util.SslCertificateTruster;
import reactor.ipc.netty.http.client.HttpClient;
import reactor.ipc.netty.resources.LoopResources;
import reactor.ipc.netty.resources.PoolResources;

/**
 * The default implementation of the {@link ConnectionContext} interface.  This is the implementation that should be used for most non-testing cases.
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_DefaultConnectionContext", generator = "Immutables")
public final class DefaultConnectionContext extends org.cloudfoundry.reactor._DefaultConnectionContext {
  private final Duration cacheDuration;
  private final @Nullable Integer connectionPoolSize;
  private final HttpClient httpClient;
  private final ObjectMapper objectMapper;
  private final RootProvider rootProvider;
  private final Integer threadPoolSize;
  private final String apiHost;
  private final Duration connectTimeout;
  private transient final Optional<PoolResources> connectionPool;
  private final Boolean keepAlive;
  private final Integer port;
  private final List<DeserializationProblemHandler> problemHandlers;
  private final ProxyConfiguration proxyConfiguration;
  private final Boolean secure;
  private final Boolean skipSslValidation;
  private transient final Optional<SslCertificateTruster> sslCertificateTruster;
  private final Duration sslCloseNotifyFlushTimeout;
  private final Duration sslCloseNotifyReadTimeout;
  private final Duration sslHandshakeTimeout;
  private transient final LoopResources threadPool;

  private DefaultConnectionContext(DefaultConnectionContext.Builder builder) {
    this.cacheDuration = builder.cacheDuration;
    this.apiHost = builder.apiHost;
    this.connectTimeout = builder.connectTimeout;
    this.keepAlive = builder.keepAlive;
    this.port = builder.port;
    this.problemHandlers = createUnmodifiableList(true, builder.problemHandlers);
    this.proxyConfiguration = builder.proxyConfiguration;
    this.secure = builder.secure;
    this.skipSslValidation = builder.skipSslValidation;
    this.sslCloseNotifyFlushTimeout = builder.sslCloseNotifyFlushTimeout;
    this.sslCloseNotifyReadTimeout = builder.sslCloseNotifyReadTimeout;
    this.sslHandshakeTimeout = builder.sslHandshakeTimeout;
    if (builder.connectionPoolSizeIsSet()) {
      initShim.connectionPoolSize(builder.connectionPoolSize);
    }
    if (builder.httpClient != null) {
      initShim.httpClient(builder.httpClient);
    }
    if (builder.objectMapper != null) {
      initShim.objectMapper(builder.objectMapper);
    }
    if (builder.rootProvider != null) {
      initShim.rootProvider(builder.rootProvider);
    }
    if (builder.threadPoolSize != null) {
      initShim.threadPoolSize(builder.threadPoolSize);
    }
    this.connectionPoolSize = initShim.getConnectionPoolSize();
    this.httpClient = initShim.getHttpClient();
    this.objectMapper = initShim.getObjectMapper();
    this.rootProvider = initShim.getRootProvider();
    this.threadPoolSize = initShim.getThreadPoolSize();
    this.connectionPool = initShim.getConnectionPool();
    this.sslCertificateTruster = initShim.getSslCertificateTruster();
    this.threadPool = initShim.getThreadPool();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private byte connectionPoolSizeBuildStage = STAGE_UNINITIALIZED;
    private Integer connectionPoolSize;

    Integer getConnectionPoolSize() {
      if (connectionPoolSizeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (connectionPoolSizeBuildStage == STAGE_UNINITIALIZED) {
        connectionPoolSizeBuildStage = STAGE_INITIALIZING;
        this.connectionPoolSize = DefaultConnectionContext.super.getConnectionPoolSize();
        connectionPoolSizeBuildStage = STAGE_INITIALIZED;
      }
      return this.connectionPoolSize;
    }

    void connectionPoolSize(Integer connectionPoolSize) {
      this.connectionPoolSize = connectionPoolSize;
      connectionPoolSizeBuildStage = STAGE_INITIALIZED;
    }

    private byte httpClientBuildStage = STAGE_UNINITIALIZED;
    private HttpClient httpClient;

    HttpClient getHttpClient() {
      if (httpClientBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (httpClientBuildStage == STAGE_UNINITIALIZED) {
        httpClientBuildStage = STAGE_INITIALIZING;
        this.httpClient = Objects.requireNonNull(DefaultConnectionContext.super.getHttpClient(), "httpClient");
        httpClientBuildStage = STAGE_INITIALIZED;
      }
      return this.httpClient;
    }

    void httpClient(HttpClient httpClient) {
      this.httpClient = httpClient;
      httpClientBuildStage = STAGE_INITIALIZED;
    }

    private byte objectMapperBuildStage = STAGE_UNINITIALIZED;
    private ObjectMapper objectMapper;

    ObjectMapper getObjectMapper() {
      if (objectMapperBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (objectMapperBuildStage == STAGE_UNINITIALIZED) {
        objectMapperBuildStage = STAGE_INITIALIZING;
        this.objectMapper = Objects.requireNonNull(DefaultConnectionContext.super.getObjectMapper(), "objectMapper");
        objectMapperBuildStage = STAGE_INITIALIZED;
      }
      return this.objectMapper;
    }

    void objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = objectMapper;
      objectMapperBuildStage = STAGE_INITIALIZED;
    }

    private byte rootProviderBuildStage = STAGE_UNINITIALIZED;
    private RootProvider rootProvider;

    RootProvider getRootProvider() {
      if (rootProviderBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (rootProviderBuildStage == STAGE_UNINITIALIZED) {
        rootProviderBuildStage = STAGE_INITIALIZING;
        this.rootProvider = Objects.requireNonNull(DefaultConnectionContext.super.getRootProvider(), "rootProvider");
        rootProviderBuildStage = STAGE_INITIALIZED;
      }
      return this.rootProvider;
    }

    void rootProvider(RootProvider rootProvider) {
      this.rootProvider = rootProvider;
      rootProviderBuildStage = STAGE_INITIALIZED;
    }

    private byte threadPoolSizeBuildStage = STAGE_UNINITIALIZED;
    private Integer threadPoolSize;

    Integer getThreadPoolSize() {
      if (threadPoolSizeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (threadPoolSizeBuildStage == STAGE_UNINITIALIZED) {
        threadPoolSizeBuildStage = STAGE_INITIALIZING;
        this.threadPoolSize = Objects.requireNonNull(DefaultConnectionContext.super.getThreadPoolSize(), "threadPoolSize");
        threadPoolSizeBuildStage = STAGE_INITIALIZED;
      }
      return this.threadPoolSize;
    }

    void threadPoolSize(Integer threadPoolSize) {
      this.threadPoolSize = threadPoolSize;
      threadPoolSizeBuildStage = STAGE_INITIALIZED;
    }

    private byte connectionPoolBuildStage = STAGE_UNINITIALIZED;
    private Optional<PoolResources> connectionPool;

    Optional<PoolResources> getConnectionPool() {
      if (connectionPoolBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (connectionPoolBuildStage == STAGE_UNINITIALIZED) {
        connectionPoolBuildStage = STAGE_INITIALIZING;
        this.connectionPool = Objects.requireNonNull(DefaultConnectionContext.super.getConnectionPool(), "connectionPool");
        connectionPoolBuildStage = STAGE_INITIALIZED;
      }
      return this.connectionPool;
    }

    private byte sslCertificateTrusterBuildStage = STAGE_UNINITIALIZED;
    private Optional<SslCertificateTruster> sslCertificateTruster;

    Optional<SslCertificateTruster> getSslCertificateTruster() {
      if (sslCertificateTrusterBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sslCertificateTrusterBuildStage == STAGE_UNINITIALIZED) {
        sslCertificateTrusterBuildStage = STAGE_INITIALIZING;
        this.sslCertificateTruster = Objects.requireNonNull(DefaultConnectionContext.super.getSslCertificateTruster(), "sslCertificateTruster");
        sslCertificateTrusterBuildStage = STAGE_INITIALIZED;
      }
      return this.sslCertificateTruster;
    }

    private byte threadPoolBuildStage = STAGE_UNINITIALIZED;
    private LoopResources threadPool;

    LoopResources getThreadPool() {
      if (threadPoolBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (threadPoolBuildStage == STAGE_UNINITIALIZED) {
        threadPoolBuildStage = STAGE_INITIALIZING;
        this.threadPool = Objects.requireNonNull(DefaultConnectionContext.super.getThreadPool(), "threadPool");
        threadPoolBuildStage = STAGE_INITIALIZED;
      }
      return this.threadPool;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (connectionPoolSizeBuildStage == STAGE_INITIALIZING) attributes.add("connectionPoolSize");
      if (httpClientBuildStage == STAGE_INITIALIZING) attributes.add("httpClient");
      if (objectMapperBuildStage == STAGE_INITIALIZING) attributes.add("objectMapper");
      if (rootProviderBuildStage == STAGE_INITIALIZING) attributes.add("rootProvider");
      if (threadPoolSizeBuildStage == STAGE_INITIALIZING) attributes.add("threadPoolSize");
      if (connectionPoolBuildStage == STAGE_INITIALIZING) attributes.add("connectionPool");
      if (sslCertificateTrusterBuildStage == STAGE_INITIALIZING) attributes.add("sslCertificateTruster");
      if (threadPoolBuildStage == STAGE_INITIALIZING) attributes.add("threadPool");
      return "Cannot build DefaultConnectionContext, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code cacheDuration} attribute
   */
  @Override
  public Optional<Duration> getCacheDuration() {
    return Optional.ofNullable(cacheDuration);
  }

  /**
   * The number of connections to use when processing requests and responses.  Setting this to {@code null} disables connection pooling.
   */
  @Override
  public @Nullable Integer getConnectionPoolSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getConnectionPoolSize()
        : this.connectionPoolSize;
  }

  /**
   * @return The value of the {@code httpClient} attribute
   */
  @Override
  public HttpClient getHttpClient() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getHttpClient()
        : this.httpClient;
  }

  /**
   * @return The value of the {@code objectMapper} attribute
   */
  @Override
  public ObjectMapper getObjectMapper() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getObjectMapper()
        : this.objectMapper;
  }

  /**
   * @return The value of the {@code rootProvider} attribute
   */
  @Override
  public RootProvider getRootProvider() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getRootProvider()
        : this.rootProvider;
  }

  /**
   * The number of worker threads to use when processing requests and responses
   */
  @Override
  public Integer getThreadPoolSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getThreadPoolSize()
        : this.threadPoolSize;
  }

  /**
   * The hostname of the API root.  Typically something like {@code api.run.pivotal.io}.
   */
  @Override
  public String getApiHost() {
    return apiHost;
  }

  /**
   * The {@code CONNECT_TIMEOUT_MILLIS} value
   */
  @Override
  public Optional<Duration> getConnectTimeout() {
    return Optional.ofNullable(connectTimeout);
  }

  /**
   * @return The computed-at-construction value of the {@code connectionPool} attribute
   */
  @Override
  public Optional<PoolResources> getConnectionPool() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getConnectionPool()
        : this.connectionPool;
  }

  /**
   * The {@code SO_KEEPALIVE} value
   */
  @Override
  public Optional<Boolean> getKeepAlive() {
    return Optional.ofNullable(keepAlive);
  }

  /**
   * The port for the Cloud Foundry instance. Defaults to {@code 443}.
   */
  @Override
  public Optional<Integer> getPort() {
    return Optional.ofNullable(port);
  }

  /**
   * Jackson deserialization problem handlers.  Typically only used for testing.
   */
  @Override
  public List<DeserializationProblemHandler> getProblemHandlers() {
    return problemHandlers;
  }

  /**
   * The (optional) proxy configuration
   */
  @Override
  public Optional<ProxyConfiguration> getProxyConfiguration() {
    return Optional.ofNullable(proxyConfiguration);
  }

  /**
   * Whether the connection to the root API should be secure (i.e. using HTTPS).  Defaults to {@code true}.
   */
  @Override
  public Optional<Boolean> getSecure() {
    return Optional.ofNullable(secure);
  }

  /**
   * Whether to skip SSL certificate validation for all hosts reachable from the API host.  Defaults to {@code false}.
   */
  @Override
  public Optional<Boolean> getSkipSslValidation() {
    return Optional.ofNullable(skipSslValidation);
  }

  /**
   * @return The computed-at-construction value of the {@code sslCertificateTruster} attribute
   */
  @Override
  public Optional<SslCertificateTruster> getSslCertificateTruster() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSslCertificateTruster()
        : this.sslCertificateTruster;
  }

  /**
   * The timeout for the SSL close notify flush
   */
  @Override
  public Optional<Duration> getSslCloseNotifyFlushTimeout() {
    return Optional.ofNullable(sslCloseNotifyFlushTimeout);
  }

  /**
   * THe timeout for the SSL close notify read
   */
  @Override
  public Optional<Duration> getSslCloseNotifyReadTimeout() {
    return Optional.ofNullable(sslCloseNotifyReadTimeout);
  }

  /**
   * The timeout for the SSL handshake negotiation
   */
  @Override
  public Optional<Duration> getSslHandshakeTimeout() {
    return Optional.ofNullable(sslHandshakeTimeout);
  }

  /**
   * @return The computed-at-construction value of the {@code threadPool} attribute
   */
  @Override
  public LoopResources getThreadPool() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getThreadPool()
        : this.threadPool;
  }

  /**
   * This instance is equal to all instances of {@code DefaultConnectionContext} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DefaultConnectionContext
        && equalTo((DefaultConnectionContext) another);
  }

  private boolean equalTo(DefaultConnectionContext another) {
    return Objects.equals(cacheDuration, another.cacheDuration)
        && Objects.equals(connectionPoolSize, another.connectionPoolSize)
        && httpClient.equals(another.httpClient)
        && objectMapper.equals(another.objectMapper)
        && rootProvider.equals(another.rootProvider)
        && threadPoolSize.equals(another.threadPoolSize)
        && apiHost.equals(another.apiHost)
        && Objects.equals(connectTimeout, another.connectTimeout)
        && connectionPool.equals(another.connectionPool)
        && Objects.equals(keepAlive, another.keepAlive)
        && Objects.equals(port, another.port)
        && problemHandlers.equals(another.problemHandlers)
        && Objects.equals(proxyConfiguration, another.proxyConfiguration)
        && Objects.equals(secure, another.secure)
        && Objects.equals(skipSslValidation, another.skipSslValidation)
        && sslCertificateTruster.equals(another.sslCertificateTruster)
        && Objects.equals(sslCloseNotifyFlushTimeout, another.sslCloseNotifyFlushTimeout)
        && Objects.equals(sslCloseNotifyReadTimeout, another.sslCloseNotifyReadTimeout)
        && Objects.equals(sslHandshakeTimeout, another.sslHandshakeTimeout)
        && threadPool.equals(another.threadPool);
  }

  /**
   * Computes a hash code from attributes: {@code cacheDuration}, {@code connectionPoolSize}, {@code httpClient}, {@code objectMapper}, {@code rootProvider}, {@code threadPoolSize}, {@code apiHost}, {@code connectTimeout}, {@code connectionPool}, {@code keepAlive}, {@code port}, {@code problemHandlers}, {@code proxyConfiguration}, {@code secure}, {@code skipSslValidation}, {@code sslCertificateTruster}, {@code sslCloseNotifyFlushTimeout}, {@code sslCloseNotifyReadTimeout}, {@code sslHandshakeTimeout}, {@code threadPool}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(cacheDuration);
    h += (h << 5) + Objects.hashCode(connectionPoolSize);
    h += (h << 5) + httpClient.hashCode();
    h += (h << 5) + objectMapper.hashCode();
    h += (h << 5) + rootProvider.hashCode();
    h += (h << 5) + threadPoolSize.hashCode();
    h += (h << 5) + apiHost.hashCode();
    h += (h << 5) + Objects.hashCode(connectTimeout);
    h += (h << 5) + connectionPool.hashCode();
    h += (h << 5) + Objects.hashCode(keepAlive);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + problemHandlers.hashCode();
    h += (h << 5) + Objects.hashCode(proxyConfiguration);
    h += (h << 5) + Objects.hashCode(secure);
    h += (h << 5) + Objects.hashCode(skipSslValidation);
    h += (h << 5) + sslCertificateTruster.hashCode();
    h += (h << 5) + Objects.hashCode(sslCloseNotifyFlushTimeout);
    h += (h << 5) + Objects.hashCode(sslCloseNotifyReadTimeout);
    h += (h << 5) + Objects.hashCode(sslHandshakeTimeout);
    h += (h << 5) + threadPool.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DefaultConnectionContext} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("DefaultConnectionContext{");
    if (cacheDuration != null) {
      builder.append("cacheDuration=").append(cacheDuration);
    }
    if (connectionPoolSize != null) {
      if (builder.length() > 25) builder.append(", ");
      builder.append("connectionPoolSize=").append(connectionPoolSize);
    }
    if (builder.length() > 25) builder.append(", ");
    builder.append("httpClient=").append(httpClient);
    builder.append(", ");
    builder.append("objectMapper=").append(objectMapper);
    builder.append(", ");
    builder.append("rootProvider=").append(rootProvider);
    builder.append(", ");
    builder.append("threadPoolSize=").append(threadPoolSize);
    builder.append(", ");
    builder.append("apiHost=").append(apiHost);
    if (connectTimeout != null) {
      builder.append(", ");
      builder.append("connectTimeout=").append(connectTimeout);
    }
    builder.append(", ");
    builder.append("connectionPool=").append(connectionPool);
    if (keepAlive != null) {
      builder.append(", ");
      builder.append("keepAlive=").append(keepAlive);
    }
    if (port != null) {
      builder.append(", ");
      builder.append("port=").append(port);
    }
    builder.append(", ");
    builder.append("problemHandlers=").append(problemHandlers);
    if (proxyConfiguration != null) {
      builder.append(", ");
      builder.append("proxyConfiguration=").append(proxyConfiguration);
    }
    if (secure != null) {
      builder.append(", ");
      builder.append("secure=").append(secure);
    }
    if (skipSslValidation != null) {
      builder.append(", ");
      builder.append("skipSslValidation=").append(skipSslValidation);
    }
    builder.append(", ");
    builder.append("sslCertificateTruster=").append(sslCertificateTruster);
    if (sslCloseNotifyFlushTimeout != null) {
      builder.append(", ");
      builder.append("sslCloseNotifyFlushTimeout=").append(sslCloseNotifyFlushTimeout);
    }
    if (sslCloseNotifyReadTimeout != null) {
      builder.append(", ");
      builder.append("sslCloseNotifyReadTimeout=").append(sslCloseNotifyReadTimeout);
    }
    if (sslHandshakeTimeout != null) {
      builder.append(", ");
      builder.append("sslHandshakeTimeout=").append(sslHandshakeTimeout);
    }
    builder.append(", ");
    builder.append("threadPool=").append(threadPool);
    return builder.append("}").toString();
  }

  /**
   * Creates a builder for {@link DefaultConnectionContext DefaultConnectionContext}.
   * @return A new DefaultConnectionContext builder
   */
  public static DefaultConnectionContext.Builder builder() {
    return new DefaultConnectionContext.Builder();
  }

  /**
   * Builds instances of type {@link DefaultConnectionContext DefaultConnectionContext}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_API_HOST = 0x1L;
    private static final long OPT_BIT_CONNECTION_POOL_SIZE = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private Duration cacheDuration;
    private Integer connectionPoolSize;
    private HttpClient httpClient;
    private ObjectMapper objectMapper;
    private RootProvider rootProvider;
    private Integer threadPoolSize;
    private String apiHost;
    private Duration connectTimeout;
    private Boolean keepAlive;
    private Integer port;
    private List<DeserializationProblemHandler> problemHandlers = new ArrayList<DeserializationProblemHandler>();
    private ProxyConfiguration proxyConfiguration;
    private Boolean secure;
    private Boolean skipSslValidation;
    private Duration sslCloseNotifyFlushTimeout;
    private Duration sslCloseNotifyReadTimeout;
    private Duration sslHandshakeTimeout;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DefaultConnectionContext} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DefaultConnectionContext instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _DefaultConnectionContext} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_DefaultConnectionContext instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.reactor.ConnectionContext} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConnectionContext instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof org.cloudfoundry.reactor._DefaultConnectionContext) {
        org.cloudfoundry.reactor._DefaultConnectionContext instance = (org.cloudfoundry.reactor._DefaultConnectionContext) object;
        if ((bits & 0x1L) == 0) {
          httpClient(instance.getHttpClient());
          bits |= 0x1L;
        }
        Optional<Duration> sslCloseNotifyReadTimeoutOptional = instance.getSslCloseNotifyReadTimeout();
        if (sslCloseNotifyReadTimeoutOptional.isPresent()) {
          sslCloseNotifyReadTimeout(sslCloseNotifyReadTimeoutOptional);
        }
        Optional<Boolean> keepAliveOptional = instance.getKeepAlive();
        if (keepAliveOptional.isPresent()) {
          keepAlive(keepAliveOptional);
        }
        apiHost(instance.getApiHost());
        Integer connectionPoolSizeValue = instance.getConnectionPoolSize();
        if (connectionPoolSizeValue != null) {
          connectionPoolSize(connectionPoolSizeValue);
        }
        Optional<Boolean> secureOptional = instance.getSecure();
        if (secureOptional.isPresent()) {
          secure(secureOptional);
        }
        Optional<Boolean> skipSslValidationOptional = instance.getSkipSslValidation();
        if (skipSslValidationOptional.isPresent()) {
          skipSslValidation(skipSslValidationOptional);
        }
        addAllProblemHandlers(instance.getProblemHandlers());
        if ((bits & 0x2L) == 0) {
          rootProvider(instance.getRootProvider());
          bits |= 0x2L;
        }
        Optional<Duration> sslCloseNotifyFlushTimeoutOptional = instance.getSslCloseNotifyFlushTimeout();
        if (sslCloseNotifyFlushTimeoutOptional.isPresent()) {
          sslCloseNotifyFlushTimeout(sslCloseNotifyFlushTimeoutOptional);
        }
        if ((bits & 0x4L) == 0) {
          objectMapper(instance.getObjectMapper());
          bits |= 0x4L;
        }
        threadPoolSize(instance.getThreadPoolSize());
        Optional<Integer> portOptional = instance.getPort();
        if (portOptional.isPresent()) {
          port(portOptional);
        }
        Optional<Duration> sslHandshakeTimeoutOptional = instance.getSslHandshakeTimeout();
        if (sslHandshakeTimeoutOptional.isPresent()) {
          sslHandshakeTimeout(sslHandshakeTimeoutOptional);
        }
        if ((bits & 0x8L) == 0) {
          Optional<Duration> cacheDurationOptional = instance.getCacheDuration();
          if (cacheDurationOptional.isPresent()) {
            cacheDuration(cacheDurationOptional);
          }
          bits |= 0x8L;
        }
        Optional<Duration> connectTimeoutOptional = instance.getConnectTimeout();
        if (connectTimeoutOptional.isPresent()) {
          connectTimeout(connectTimeoutOptional);
        }
        Optional<ProxyConfiguration> proxyConfigurationOptional = instance.getProxyConfiguration();
        if (proxyConfigurationOptional.isPresent()) {
          proxyConfiguration(proxyConfigurationOptional);
        }
      }
      if (object instanceof ConnectionContext) {
        ConnectionContext instance = (ConnectionContext) object;
        if ((bits & 0x1L) == 0) {
          httpClient(instance.getHttpClient());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          objectMapper(instance.getObjectMapper());
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          rootProvider(instance.getRootProvider());
          bits |= 0x2L;
        }
        if ((bits & 0x8L) == 0) {
          Optional<Duration> cacheDurationOptional = instance.getCacheDuration();
          if (cacheDurationOptional.isPresent()) {
            cacheDuration(cacheDurationOptional);
          }
          bits |= 0x8L;
        }
      }
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getCacheDuration() cacheDuration} to cacheDuration.
     * @param cacheDuration The value for cacheDuration
     * @return {@code this} builder for chained invocation
     */
    public final Builder cacheDuration(Duration cacheDuration) {
      this.cacheDuration = Objects.requireNonNull(cacheDuration, "cacheDuration");
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getCacheDuration() cacheDuration} to cacheDuration.
     * @param cacheDuration The value for cacheDuration
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cacheDuration(Optional<? extends Duration> cacheDuration) {
      this.cacheDuration = cacheDuration.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultConnectionContext#getConnectionPoolSize() connectionPoolSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DefaultConnectionContext#getConnectionPoolSize() connectionPoolSize}.</em>
     * @param connectionPoolSize The value for connectionPoolSize (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectionPoolSize(@Nullable Integer connectionPoolSize) {
      this.connectionPoolSize = connectionPoolSize;
      optBits |= OPT_BIT_CONNECTION_POOL_SIZE;
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultConnectionContext#getHttpClient() httpClient} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DefaultConnectionContext#getHttpClient() httpClient}.</em>
     * @param httpClient The value for httpClient 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder httpClient(HttpClient httpClient) {
      this.httpClient = Objects.requireNonNull(httpClient, "httpClient");
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultConnectionContext#getObjectMapper() objectMapper} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DefaultConnectionContext#getObjectMapper() objectMapper}.</em>
     * @param objectMapper The value for objectMapper 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder objectMapper(ObjectMapper objectMapper) {
      this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultConnectionContext#getRootProvider() rootProvider} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DefaultConnectionContext#getRootProvider() rootProvider}.</em>
     * @param rootProvider The value for rootProvider 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rootProvider(RootProvider rootProvider) {
      this.rootProvider = Objects.requireNonNull(rootProvider, "rootProvider");
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultConnectionContext#getThreadPoolSize() threadPoolSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link DefaultConnectionContext#getThreadPoolSize() threadPoolSize}.</em>
     * @param threadPoolSize The value for threadPoolSize 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder threadPoolSize(Integer threadPoolSize) {
      this.threadPoolSize = Objects.requireNonNull(threadPoolSize, "threadPoolSize");
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultConnectionContext#getApiHost() apiHost} attribute.
     * @param apiHost The value for apiHost 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder apiHost(String apiHost) {
      this.apiHost = Objects.requireNonNull(apiHost, "apiHost");
      initBits &= ~INIT_BIT_API_HOST;
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getConnectTimeout() connectTimeout} to connectTimeout.
     * @param connectTimeout The value for connectTimeout
     * @return {@code this} builder for chained invocation
     */
    public final Builder connectTimeout(Duration connectTimeout) {
      this.connectTimeout = Objects.requireNonNull(connectTimeout, "connectTimeout");
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getConnectTimeout() connectTimeout} to connectTimeout.
     * @param connectTimeout The value for connectTimeout
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder connectTimeout(Optional<? extends Duration> connectTimeout) {
      this.connectTimeout = connectTimeout.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getKeepAlive() keepAlive} to keepAlive.
     * @param keepAlive The value for keepAlive
     * @return {@code this} builder for chained invocation
     */
    public final Builder keepAlive(boolean keepAlive) {
      this.keepAlive = keepAlive;
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getKeepAlive() keepAlive} to keepAlive.
     * @param keepAlive The value for keepAlive
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder keepAlive(Optional<Boolean> keepAlive) {
      this.keepAlive = keepAlive.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(int port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(Optional<Integer> port) {
      this.port = port.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link DefaultConnectionContext#getProblemHandlers() problemHandlers} list.
     * @param element A problemHandlers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder problemHandler(DeserializationProblemHandler element) {
      this.problemHandlers.add(Objects.requireNonNull(element, "problemHandlers element"));
      return this;
    }

    /**
     * Adds elements to {@link DefaultConnectionContext#getProblemHandlers() problemHandlers} list.
     * @param elements An array of problemHandlers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder problemHandlers(DeserializationProblemHandler... elements) {
      for (DeserializationProblemHandler element : elements) {
        this.problemHandlers.add(Objects.requireNonNull(element, "problemHandlers element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DefaultConnectionContext#getProblemHandlers() problemHandlers} list.
     * @param elements An iterable of problemHandlers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder problemHandlers(Iterable<? extends DeserializationProblemHandler> elements) {
      this.problemHandlers.clear();
      return addAllProblemHandlers(elements);
    }

    /**
     * Adds elements to {@link DefaultConnectionContext#getProblemHandlers() problemHandlers} list.
     * @param elements An iterable of problemHandlers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllProblemHandlers(Iterable<? extends DeserializationProblemHandler> elements) {
      for (DeserializationProblemHandler element : elements) {
        this.problemHandlers.add(Objects.requireNonNull(element, "problemHandlers element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getProxyConfiguration() proxyConfiguration} to proxyConfiguration.
     * @param proxyConfiguration The value for proxyConfiguration
     * @return {@code this} builder for chained invocation
     */
    public final Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
      this.proxyConfiguration = Objects.requireNonNull(proxyConfiguration, "proxyConfiguration");
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getProxyConfiguration() proxyConfiguration} to proxyConfiguration.
     * @param proxyConfiguration The value for proxyConfiguration
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder proxyConfiguration(Optional<? extends ProxyConfiguration> proxyConfiguration) {
      this.proxyConfiguration = proxyConfiguration.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getSecure() secure} to secure.
     * @param secure The value for secure
     * @return {@code this} builder for chained invocation
     */
    public final Builder secure(boolean secure) {
      this.secure = secure;
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getSecure() secure} to secure.
     * @param secure The value for secure
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder secure(Optional<Boolean> secure) {
      this.secure = secure.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getSkipSslValidation() skipSslValidation} to skipSslValidation.
     * @param skipSslValidation The value for skipSslValidation
     * @return {@code this} builder for chained invocation
     */
    public final Builder skipSslValidation(boolean skipSslValidation) {
      this.skipSslValidation = skipSslValidation;
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getSkipSslValidation() skipSslValidation} to skipSslValidation.
     * @param skipSslValidation The value for skipSslValidation
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder skipSslValidation(Optional<Boolean> skipSslValidation) {
      this.skipSslValidation = skipSslValidation.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getSslCloseNotifyFlushTimeout() sslCloseNotifyFlushTimeout} to sslCloseNotifyFlushTimeout.
     * @param sslCloseNotifyFlushTimeout The value for sslCloseNotifyFlushTimeout
     * @return {@code this} builder for chained invocation
     */
    public final Builder sslCloseNotifyFlushTimeout(Duration sslCloseNotifyFlushTimeout) {
      this.sslCloseNotifyFlushTimeout = Objects.requireNonNull(sslCloseNotifyFlushTimeout, "sslCloseNotifyFlushTimeout");
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getSslCloseNotifyFlushTimeout() sslCloseNotifyFlushTimeout} to sslCloseNotifyFlushTimeout.
     * @param sslCloseNotifyFlushTimeout The value for sslCloseNotifyFlushTimeout
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sslCloseNotifyFlushTimeout(Optional<? extends Duration> sslCloseNotifyFlushTimeout) {
      this.sslCloseNotifyFlushTimeout = sslCloseNotifyFlushTimeout.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getSslCloseNotifyReadTimeout() sslCloseNotifyReadTimeout} to sslCloseNotifyReadTimeout.
     * @param sslCloseNotifyReadTimeout The value for sslCloseNotifyReadTimeout
     * @return {@code this} builder for chained invocation
     */
    public final Builder sslCloseNotifyReadTimeout(Duration sslCloseNotifyReadTimeout) {
      this.sslCloseNotifyReadTimeout = Objects.requireNonNull(sslCloseNotifyReadTimeout, "sslCloseNotifyReadTimeout");
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getSslCloseNotifyReadTimeout() sslCloseNotifyReadTimeout} to sslCloseNotifyReadTimeout.
     * @param sslCloseNotifyReadTimeout The value for sslCloseNotifyReadTimeout
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sslCloseNotifyReadTimeout(Optional<? extends Duration> sslCloseNotifyReadTimeout) {
      this.sslCloseNotifyReadTimeout = sslCloseNotifyReadTimeout.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getSslHandshakeTimeout() sslHandshakeTimeout} to sslHandshakeTimeout.
     * @param sslHandshakeTimeout The value for sslHandshakeTimeout
     * @return {@code this} builder for chained invocation
     */
    public final Builder sslHandshakeTimeout(Duration sslHandshakeTimeout) {
      this.sslHandshakeTimeout = Objects.requireNonNull(sslHandshakeTimeout, "sslHandshakeTimeout");
      return this;
    }

    /**
     * Initializes the optional value {@link DefaultConnectionContext#getSslHandshakeTimeout() sslHandshakeTimeout} to sslHandshakeTimeout.
     * @param sslHandshakeTimeout The value for sslHandshakeTimeout
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sslHandshakeTimeout(Optional<? extends Duration> sslHandshakeTimeout) {
      this.sslHandshakeTimeout = sslHandshakeTimeout.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link DefaultConnectionContext DefaultConnectionContext}.
     * @return An immutable instance of DefaultConnectionContext
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DefaultConnectionContext build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DefaultConnectionContext(this);
    }

    private boolean connectionPoolSizeIsSet() {
      return (optBits & OPT_BIT_CONNECTION_POOL_SIZE) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_API_HOST) != 0) attributes.add("apiHost");
      return "Cannot build DefaultConnectionContext, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
