/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.reactor.AbstractRootProvider;
import org.cloudfoundry.reactor.InfoPayloadRootProvider;
import org.cloudfoundry.reactor.RootPayloadRootProvider;
import org.cloudfoundry.reactor._DelegatingRootProvider;
import org.immutables.value.Generated;

@Generated(from="_DelegatingRootProvider", generator="Immutables")
public final class DelegatingRootProvider
extends _DelegatingRootProvider {
    private final transient InfoPayloadRootProvider infoPayloadRootProvider;
    private final ObjectMapper objectMapper;
    private final transient RootPayloadRootProvider rootPayloadRootProvider;
    private final String apiHost;
    private final Integer port;
    private final Boolean secure;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private DelegatingRootProvider(Builder builder) {
        this.objectMapper = builder.objectMapper;
        this.apiHost = builder.apiHost;
        this.port = builder.port;
        this.secure = builder.secure;
        this.infoPayloadRootProvider = this.initShim.getInfoPayloadRootProvider();
        this.rootPayloadRootProvider = this.initShim.getRootPayloadRootProvider();
        this.initShim = null;
    }

    @Override
    public InfoPayloadRootProvider getInfoPayloadRootProvider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getInfoPayloadRootProvider() : this.infoPayloadRootProvider;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public RootPayloadRootProvider getRootPayloadRootProvider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRootPayloadRootProvider() : this.rootPayloadRootProvider;
    }

    @Override
    public String getApiHost() {
        return this.apiHost;
    }

    @Override
    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.port);
    }

    @Override
    public Optional<Boolean> getSecure() {
        return Optional.ofNullable(this.secure);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DelegatingRootProvider && this.equalTo((DelegatingRootProvider)another);
    }

    private boolean equalTo(DelegatingRootProvider another) {
        return this.infoPayloadRootProvider.equals(another.infoPayloadRootProvider) && this.objectMapper.equals(another.objectMapper) && this.rootPayloadRootProvider.equals(another.rootPayloadRootProvider) && this.apiHost.equals(another.apiHost) && Objects.equals(this.port, another.port) && Objects.equals(this.secure, another.secure);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.infoPayloadRootProvider.hashCode();
        h += (h << 5) + this.objectMapper.hashCode();
        h += (h << 5) + this.rootPayloadRootProvider.hashCode();
        h += (h << 5) + this.apiHost.hashCode();
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Objects.hashCode(this.secure);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DelegatingRootProvider{");
        builder.append("infoPayloadRootProvider=").append(this.infoPayloadRootProvider);
        builder.append(", ");
        builder.append("objectMapper=").append(this.objectMapper);
        builder.append(", ");
        builder.append("rootPayloadRootProvider=").append(this.rootPayloadRootProvider);
        builder.append(", ");
        builder.append("apiHost=").append(this.apiHost);
        if (this.port != null) {
            builder.append(", ");
            builder.append("port=").append(this.port);
        }
        if (this.secure != null) {
            builder.append(", ");
            builder.append("secure=").append(this.secure);
        }
        return builder.append("}").toString();
    }

    private static DelegatingRootProvider validate(DelegatingRootProvider instance) {
        instance.checkForValidApiHost();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OBJECT_MAPPER = 1L;
        private static final long INIT_BIT_API_HOST = 2L;
        private long initBits = 3L;
        private ObjectMapper objectMapper;
        private String apiHost;
        private Integer port;
        private Boolean secure;

        private Builder() {
        }

        public final Builder from(AbstractRootProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DelegatingRootProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_DelegatingRootProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractRootProvider instance;
            if (object instanceof AbstractRootProvider) {
                Optional<Integer> portOptional;
                instance = (AbstractRootProvider)object;
                Optional<Boolean> secureOptional = instance.getSecure();
                if (secureOptional.isPresent()) {
                    this.secure(secureOptional);
                }
                if ((portOptional = instance.getPort()).isPresent()) {
                    this.port(portOptional);
                }
                this.apiHost(instance.getApiHost());
            }
            if (object instanceof _DelegatingRootProvider) {
                instance = (_DelegatingRootProvider)object;
                this.objectMapper(((_DelegatingRootProvider)instance).getObjectMapper());
            }
        }

        public final Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder apiHost(String apiHost) {
            this.apiHost = Objects.requireNonNull(apiHost, "apiHost");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        public final Builder port(Optional<Integer> port) {
            this.port = port.orElse(null);
            return this;
        }

        public final Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public final Builder secure(Optional<Boolean> secure) {
            this.secure = secure.orElse(null);
            return this;
        }

        public DelegatingRootProvider build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return DelegatingRootProvider.validate(new DelegatingRootProvider(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("objectMapper");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("apiHost");
            }
            return "Cannot build DelegatingRootProvider, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte infoPayloadRootProviderBuildStage = 0;
        private InfoPayloadRootProvider infoPayloadRootProvider;
        private byte rootPayloadRootProviderBuildStage = 0;
        private RootPayloadRootProvider rootPayloadRootProvider;

        private InitShim() {
        }

        InfoPayloadRootProvider getInfoPayloadRootProvider() {
            if (this.infoPayloadRootProviderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.infoPayloadRootProviderBuildStage == 0) {
                this.infoPayloadRootProviderBuildStage = (byte)-1;
                this.infoPayloadRootProvider = Objects.requireNonNull(DelegatingRootProvider.super.getInfoPayloadRootProvider(), "infoPayloadRootProvider");
                this.infoPayloadRootProviderBuildStage = 1;
            }
            return this.infoPayloadRootProvider;
        }

        RootPayloadRootProvider getRootPayloadRootProvider() {
            if (this.rootPayloadRootProviderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rootPayloadRootProviderBuildStage == 0) {
                this.rootPayloadRootProviderBuildStage = (byte)-1;
                this.rootPayloadRootProvider = Objects.requireNonNull(DelegatingRootProvider.super.getRootPayloadRootProvider(), "rootPayloadRootProvider");
                this.rootPayloadRootProviderBuildStage = 1;
            }
            return this.rootPayloadRootProvider;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.infoPayloadRootProviderBuildStage == -1) {
                attributes.add("infoPayloadRootProvider");
            }
            if (this.rootPayloadRootProviderBuildStage == -1) {
                attributes.add("rootPayloadRootProvider");
            }
            return "Cannot build DelegatingRootProvider, attribute initializers form cycle " + attributes;
        }
    }
}

