/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.doppler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.core.publisher.Flux;
import reactor.ipc.netty.http.client.HttpClientResponse;

final class MultipartCodec {
    private static final Pattern BOUNDARY_PATTERN = Pattern.compile("multipart/.+; boundary=(.*)");
    private static final int MAX_PAYLOAD_SIZE = 0x100000;

    private MultipartCodec() {
    }

    static Flux<InputStream> decode(HttpClientResponse response) {
        return response.addHandler((ChannelHandler)MultipartCodec.createDecoder(response)).receive().asInputStream().skip(1L);
    }

    private static DelimiterBasedFrameDecoder createDecoder(HttpClientResponse response) {
        String boundary = MultipartCodec.extractMultipartBoundary(response);
        return new DelimiterBasedFrameDecoder(0x100000, new ByteBuf[]{Unpooled.copiedBuffer((CharSequence)String.format("--%s\r\n\r\n", boundary), (Charset)Charset.defaultCharset()), Unpooled.copiedBuffer((CharSequence)String.format("\r\n--%s\r\n\r\n", boundary), (Charset)Charset.defaultCharset()), Unpooled.copiedBuffer((CharSequence)String.format("\r\n--%s--", boundary), (Charset)Charset.defaultCharset()), Unpooled.copiedBuffer((CharSequence)String.format("\r\n--%s--\r\n", boundary), (Charset)Charset.defaultCharset())});
    }

    private static String extractMultipartBoundary(HttpClientResponse response) {
        String contentType = response.responseHeaders().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
        Matcher matcher = BOUNDARY_PATTERN.matcher(contentType);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalStateException(String.format("Content-Type %s does not contain a valid multipart boundary", contentType));
    }
}

