/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.RootProvider;
import org.immutables.value.Value;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

abstract class AbstractRootProvider
implements RootProvider {
    private static final int DEFAULT_PORT = 443;
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^[a-zA-Z0-9-.]+$");
    private static final int UNDEFINED_PORT = -1;

    AbstractRootProvider() {
    }

    @Value.Check
    public final void checkForValidApiHost() {
        Matcher matcher = HOSTNAME_PATTERN.matcher(this.getApiHost());
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("API hostname %s is not correctly formatted (e.g. 'api.local.pcfdev.io')", this.getApiHost()));
        }
    }

    public abstract String getApiHost();

    @Override
    public final Mono<String> getRoot(ConnectionContext connectionContext) {
        Mono cached = this.doGetRoot(connectionContext).delayUntil(uri -> this.trust(uri.getHost(), uri.getPort(), connectionContext)).map(UriComponents::toUriString);
        return connectionContext.getCacheDuration().map(arg_0 -> ((Mono)cached).cache(arg_0)).orElseGet(() -> ((Mono)cached).cache());
    }

    @Override
    public final Mono<String> getRoot(String key, ConnectionContext connectionContext) {
        Mono cached = this.doGetRoot(key, connectionContext).delayUntil(uri -> this.trust(uri.getHost(), uri.getPort(), connectionContext)).map(UriComponents::toUriString);
        return connectionContext.getCacheDuration().map(arg_0 -> ((Mono)cached).cache(arg_0)).orElseGet(() -> ((Mono)cached).cache());
    }

    protected abstract Mono<UriComponents> doGetRoot(ConnectionContext var1);

    protected abstract Mono<UriComponents> doGetRoot(String var1, ConnectionContext var2);

    protected final UriComponents getRoot() {
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance().scheme("https").host(this.getApiHost());
        this.getPort().ifPresent(arg_0 -> ((UriComponentsBuilder)builder).port(arg_0));
        return this.normalize(builder);
    }

    protected final UriComponents normalize(UriComponentsBuilder builder) {
        UriComponents components = builder.build();
        builder.scheme(this.getScheme());
        if (-1 == components.getPort()) {
            builder.port(this.getPort().orElse(443).intValue());
        }
        return builder.build().encode();
    }

    abstract Optional<Integer> getPort();

    abstract Optional<Boolean> getSecure();

    private String getScheme() {
        if (this.getSecure().orElse(true).booleanValue()) {
            return "https";
        }
        return "http";
    }

    private Mono<Void> trust(String host, int port, ConnectionContext connectionContext) {
        return connectionContext.trust(host, port);
    }
}

