/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.reactor.AbstractRootProvider;
import org.cloudfoundry.reactor._InfoPayloadRootProvider;
import org.immutables.value.Generated;

@Generated(from="_InfoPayloadRootProvider", generator="Immutables")
public final class InfoPayloadRootProvider
extends _InfoPayloadRootProvider {
    private final ObjectMapper objectMapper;
    private final String apiHost;
    private final Integer port;
    private final Boolean secure;

    private InfoPayloadRootProvider(Builder builder) {
        this.objectMapper = builder.objectMapper;
        this.apiHost = builder.apiHost;
        this.port = builder.port;
        this.secure = builder.secure;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public String getApiHost() {
        return this.apiHost;
    }

    @Override
    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.port);
    }

    @Override
    public Optional<Boolean> getSecure() {
        return Optional.ofNullable(this.secure);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InfoPayloadRootProvider && this.equalTo((InfoPayloadRootProvider)another);
    }

    private boolean equalTo(InfoPayloadRootProvider another) {
        return this.objectMapper.equals(another.objectMapper) && this.apiHost.equals(another.apiHost) && Objects.equals(this.port, another.port) && Objects.equals(this.secure, another.secure);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.objectMapper.hashCode();
        h += (h << 5) + this.apiHost.hashCode();
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Objects.hashCode(this.secure);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("InfoPayloadRootProvider{");
        builder.append("objectMapper=").append(this.objectMapper);
        builder.append(", ");
        builder.append("apiHost=").append(this.apiHost);
        if (this.port != null) {
            builder.append(", ");
            builder.append("port=").append(this.port);
        }
        if (this.secure != null) {
            builder.append(", ");
            builder.append("secure=").append(this.secure);
        }
        return builder.append("}").toString();
    }

    private static InfoPayloadRootProvider validate(InfoPayloadRootProvider instance) {
        instance.checkForValidApiHost();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OBJECT_MAPPER = 1L;
        private static final long INIT_BIT_API_HOST = 2L;
        private long initBits = 3L;
        private ObjectMapper objectMapper;
        private String apiHost;
        private Integer port;
        private Boolean secure;

        private Builder() {
        }

        public final Builder from(AbstractRootProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InfoPayloadRootProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_InfoPayloadRootProvider instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractRootProvider instance;
            if (object instanceof AbstractRootProvider) {
                Optional<Integer> portOptional;
                instance = (AbstractRootProvider)object;
                Optional<Boolean> secureOptional = instance.getSecure();
                if (secureOptional.isPresent()) {
                    this.secure(secureOptional);
                }
                if ((portOptional = instance.getPort()).isPresent()) {
                    this.port(portOptional);
                }
                this.apiHost(instance.getApiHost());
            }
            if (object instanceof _InfoPayloadRootProvider) {
                instance = (_InfoPayloadRootProvider)object;
                this.objectMapper(((_InfoPayloadRootProvider)instance).getObjectMapper());
            }
        }

        public final Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder apiHost(String apiHost) {
            this.apiHost = Objects.requireNonNull(apiHost, "apiHost");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        public final Builder port(Optional<Integer> port) {
            this.port = port.orElse(null);
            return this;
        }

        public final Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public final Builder secure(Optional<Boolean> secure) {
            this.secure = secure.orElse(null);
            return this;
        }

        public InfoPayloadRootProvider build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return InfoPayloadRootProvider.validate(new InfoPayloadRootProvider(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("objectMapper");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("apiHost");
            }
            return "Cannot build InfoPayloadRootProvider, some of required attributes are not set " + attributes;
        }
    }
}

