/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.DelegatingRootProvider;
import org.cloudfoundry.reactor.ProxyConfiguration;
import org.cloudfoundry.reactor.RootProvider;
import org.cloudfoundry.reactor.util.ByteBufAllocatorMetricProviderWrapper;
import org.cloudfoundry.reactor.util.DefaultSslCertificateTruster;
import org.cloudfoundry.reactor.util.SslCertificateTruster;
import org.cloudfoundry.reactor.util.StaticTrustManagerFactory;
import org.immutables.value.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClient;
import reactor.ipc.netty.http.client.HttpClientOptions;
import reactor.ipc.netty.options.ClientOptions;
import reactor.ipc.netty.resources.LoopResources;
import reactor.ipc.netty.resources.PoolResources;

@Value.Immutable
abstract class _DefaultConnectionContext
implements ConnectionContext {
    private static final int DEFAULT_PORT = 443;
    private static final int RECEIVE_BUFFER_SIZE = 0xA00000;
    private static final int SEND_BUFFER_SIZE = 0xA00000;
    private final Logger logger = LoggerFactory.getLogger((String)"cloudfoundry-client");

    _DefaultConnectionContext() {
    }

    @PreDestroy
    public final void dispose() {
        this.getConnectionPool().ifPresent(PoolResources::dispose);
        this.getThreadPool().dispose();
        try {
            ObjectName name = this.getByteBufAllocatorObjectName();
            if (ManagementFactory.getPlatformMBeanServer().isRegistered(name)) {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(name);
            }
        }
        catch (JMException e) {
            this.logger.error("Unable to register ByteBufAllocator MBean", (Throwable)e);
        }
    }

    @Override
    public abstract Optional<Duration> getCacheDuration();

    @Nullable
    @Value.Default
    public Integer getConnectionPoolSize() {
        return PoolResources.DEFAULT_POOL_MAX_CONNECTION;
    }

    @Override
    @Value.Default
    public HttpClient getHttpClient() {
        return HttpClient.create(options -> {
            ((HttpClientOptions.Builder)((HttpClientOptions.Builder)((HttpClientOptions.Builder)options.compression(true).loopResources(this.getThreadPool())).option(ChannelOption.SO_SNDBUF, (Object)0xA00000)).option(ChannelOption.SO_RCVBUF, (Object)0xA00000)).disablePool();
            options.sslSupport(ssl -> this.getSslCertificateTruster().ifPresent(trustManager -> ssl.trustManager((TrustManagerFactory)((Object)new StaticTrustManagerFactory((TrustManager)trustManager)))));
            this.getConnectionPool().ifPresent(arg_0 -> ((HttpClientOptions.Builder)options).poolResources(arg_0));
            this.getConnectTimeout().ifPresent(socketTimeout -> {
                HttpClientOptions.Builder cfr_ignored_0 = (HttpClientOptions.Builder)options.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)socketTimeout.toMillis()));
            });
            this.getKeepAlive().ifPresent(keepAlive -> {
                HttpClientOptions.Builder cfr_ignored_0 = (HttpClientOptions.Builder)options.option(ChannelOption.SO_KEEPALIVE, keepAlive);
            });
            this.getSslHandshakeTimeout().ifPresent(arg_0 -> ((HttpClientOptions.Builder)options).sslHandshakeTimeout(arg_0));
            this.getSslCloseNotifyFlushTimeout().ifPresent(arg_0 -> ((HttpClientOptions.Builder)options).sslCloseNotifyFlushTimeout(arg_0));
            this.getSslCloseNotifyReadTimeout().ifPresent(arg_0 -> ((HttpClientOptions.Builder)options).sslCloseNotifyReadTimeout(arg_0));
            this.getProxyConfiguration().ifPresent(c -> c.configure((ClientOptions.Builder)options));
        });
    }

    @Override
    @Value.Default
    public ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY).registerModule((Module)new Jdk8Module()).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.getProblemHandlers().forEach(arg_0 -> ((ObjectMapper)objectMapper).addHandler(arg_0));
        return objectMapper;
    }

    @Override
    @Value.Default
    public RootProvider getRootProvider() {
        return DelegatingRootProvider.builder().apiHost(this.getApiHost()).objectMapper(this.getObjectMapper()).port(this.getPort()).secure(this.getSecure()).build();
    }

    @Value.Default
    public Integer getThreadPoolSize() {
        return LoopResources.DEFAULT_IO_WORKER_COUNT;
    }

    @Override
    public Mono<Void> trust(String host, int port) {
        return this.getSslCertificateTruster().map(t -> t.trust(host, port, Duration.ofSeconds(30L))).orElse(Mono.empty());
    }

    abstract String getApiHost();

    abstract Optional<Duration> getConnectTimeout();

    @Value.Derived
    Optional<PoolResources> getConnectionPool() {
        return Optional.ofNullable(this.getConnectionPoolSize()).map(connectionPoolSize -> PoolResources.fixed((String)"cloudfoundry-client", (int)connectionPoolSize));
    }

    abstract Optional<Boolean> getKeepAlive();

    abstract Optional<Integer> getPort();

    abstract List<DeserializationProblemHandler> getProblemHandlers();

    abstract Optional<ProxyConfiguration> getProxyConfiguration();

    abstract Optional<Boolean> getSecure();

    abstract Optional<Boolean> getSkipSslValidation();

    @Value.Derived
    Optional<SslCertificateTruster> getSslCertificateTruster() {
        if (this.getSkipSslValidation().orElse(false).booleanValue()) {
            return Optional.of(new DefaultSslCertificateTruster(this.getProxyConfiguration(), this.getThreadPool()));
        }
        return Optional.empty();
    }

    abstract Optional<Duration> getSslCloseNotifyFlushTimeout();

    abstract Optional<Duration> getSslCloseNotifyReadTimeout();

    abstract Optional<Duration> getSslHandshakeTimeout();

    @Value.Derived
    LoopResources getThreadPool() {
        return LoopResources.create((String)"cloudfoundry-client", (int)this.getThreadPoolSize(), (boolean)true);
    }

    @PostConstruct
    void monitorByteBufAllocator() {
        try {
            ObjectName name = this.getByteBufAllocatorObjectName();
            if (ManagementFactory.getPlatformMBeanServer().isRegistered(name)) {
                this.logger.warn("MBean '{}' is already registered and will be removed. You should only have a single DefaultConnectionContext per endpoint.", (Object)name);
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(name);
            }
            ManagementFactory.getPlatformMBeanServer().registerMBean(new ByteBufAllocatorMetricProviderWrapper((ByteBufAllocatorMetricProvider)PooledByteBufAllocator.DEFAULT), name);
        }
        catch (JMException e) {
            this.logger.error("Unable to register ByteBufAllocator MBean", (Throwable)e);
        }
    }

    private ObjectName getByteBufAllocatorObjectName() throws MalformedObjectNameException {
        return ObjectName.getInstance(String.format("org.cloudfoundry.reactor:type=ByteBufAllocator,endpoint=%s/%d", this.getApiHost(), this.getPort().orElse(443)));
    }
}

