/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3.applications;

import org.cloudfoundry.client.v3.applications.ApplicationsV3;
import org.cloudfoundry.client.v3.applications.CreateApplicationRequest;
import org.cloudfoundry.client.v3.applications.CreateApplicationResponse;
import org.cloudfoundry.client.v3.applications.DeleteApplicationRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationCurrentDropletRelationshipRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationCurrentDropletRelationshipResponse;
import org.cloudfoundry.client.v3.applications.GetApplicationCurrentDropletRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationCurrentDropletResponse;
import org.cloudfoundry.client.v3.applications.GetApplicationEnvironmentRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationEnvironmentResponse;
import org.cloudfoundry.client.v3.applications.GetApplicationEnvironmentVariablesRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationEnvironmentVariablesResponse;
import org.cloudfoundry.client.v3.applications.GetApplicationProcessRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationProcessResponse;
import org.cloudfoundry.client.v3.applications.GetApplicationProcessStatisticsRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationProcessStatisticsResponse;
import org.cloudfoundry.client.v3.applications.GetApplicationRequest;
import org.cloudfoundry.client.v3.applications.GetApplicationResponse;
import org.cloudfoundry.client.v3.applications.ListApplicationBuildsRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationBuildsResponse;
import org.cloudfoundry.client.v3.applications.ListApplicationDropletsRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationDropletsResponse;
import org.cloudfoundry.client.v3.applications.ListApplicationPackagesRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationPackagesResponse;
import org.cloudfoundry.client.v3.applications.ListApplicationProcessesRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationProcessesResponse;
import org.cloudfoundry.client.v3.applications.ListApplicationTasksRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationTasksResponse;
import org.cloudfoundry.client.v3.applications.ListApplicationsRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationsResponse;
import org.cloudfoundry.client.v3.applications.ScaleApplicationRequest;
import org.cloudfoundry.client.v3.applications.ScaleApplicationResponse;
import org.cloudfoundry.client.v3.applications.SetApplicationCurrentDropletRequest;
import org.cloudfoundry.client.v3.applications.SetApplicationCurrentDropletResponse;
import org.cloudfoundry.client.v3.applications.StartApplicationRequest;
import org.cloudfoundry.client.v3.applications.StartApplicationResponse;
import org.cloudfoundry.client.v3.applications.StopApplicationRequest;
import org.cloudfoundry.client.v3.applications.StopApplicationResponse;
import org.cloudfoundry.client.v3.applications.TerminateApplicationInstanceRequest;
import org.cloudfoundry.client.v3.applications.UpdateApplicationEnvironmentVariablesRequest;
import org.cloudfoundry.client.v3.applications.UpdateApplicationEnvironmentVariablesResponse;
import org.cloudfoundry.client.v3.applications.UpdateApplicationRequest;
import org.cloudfoundry.client.v3.applications.UpdateApplicationResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v3.AbstractClientV3Operations;
import reactor.core.publisher.Mono;

public final class ReactorApplicationsV3
extends AbstractClientV3Operations
implements ApplicationsV3 {
    public ReactorApplicationsV3(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<CreateApplicationResponse> create(CreateApplicationRequest request) {
        return this.post(request, CreateApplicationResponse.class, builder -> builder.pathSegment(new String[]{"apps"})).checkpoint();
    }

    public Mono<String> delete(DeleteApplicationRequest request) {
        return this.delete(request, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId()})).checkpoint();
    }

    public Mono<GetApplicationResponse> get(GetApplicationRequest request) {
        return this.get(request, GetApplicationResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId()})).checkpoint();
    }

    public Mono<GetApplicationCurrentDropletResponse> getCurrentDroplet(GetApplicationCurrentDropletRequest request) {
        return this.get(request, GetApplicationCurrentDropletResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "droplets", "current"})).checkpoint();
    }

    public Mono<GetApplicationCurrentDropletRelationshipResponse> getCurrentDropletRelationship(GetApplicationCurrentDropletRelationshipRequest request) {
        return this.get(request, GetApplicationCurrentDropletRelationshipResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "relationships", "current_droplet"})).checkpoint();
    }

    public Mono<GetApplicationEnvironmentResponse> getEnvironment(GetApplicationEnvironmentRequest request) {
        return this.get(request, GetApplicationEnvironmentResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "env"})).checkpoint();
    }

    public Mono<GetApplicationEnvironmentVariablesResponse> getEnvironmentVariables(GetApplicationEnvironmentVariablesRequest request) {
        return this.get(request, GetApplicationEnvironmentVariablesResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "environment_variables"})).checkpoint();
    }

    public Mono<GetApplicationProcessResponse> getProcess(GetApplicationProcessRequest request) {
        return this.get(request, GetApplicationProcessResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "processes", request.getType()})).checkpoint();
    }

    public Mono<GetApplicationProcessStatisticsResponse> getProcessStatistics(GetApplicationProcessStatisticsRequest request) {
        return this.get(request, GetApplicationProcessStatisticsResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "processes", request.getType(), "stats"})).checkpoint();
    }

    public Mono<ListApplicationsResponse> list(ListApplicationsRequest request) {
        return this.get(request, ListApplicationsResponse.class, builder -> builder.pathSegment(new String[]{"apps"})).checkpoint();
    }

    public Mono<ListApplicationBuildsResponse> listBuilds(ListApplicationBuildsRequest request) {
        return this.get(request, ListApplicationBuildsResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "builds"})).checkpoint();
    }

    public Mono<ListApplicationDropletsResponse> listDroplets(ListApplicationDropletsRequest request) {
        return this.get(request, ListApplicationDropletsResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "droplets"})).checkpoint();
    }

    public Mono<ListApplicationPackagesResponse> listPackages(ListApplicationPackagesRequest request) {
        return this.get(request, ListApplicationPackagesResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "packages"})).checkpoint();
    }

    public Mono<ListApplicationProcessesResponse> listProcesses(ListApplicationProcessesRequest request) {
        return this.get(request, ListApplicationProcessesResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "processes"})).checkpoint();
    }

    public Mono<ListApplicationTasksResponse> listTasks(ListApplicationTasksRequest request) {
        return this.get(request, ListApplicationTasksResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "tasks"})).checkpoint();
    }

    public Mono<ScaleApplicationResponse> scale(ScaleApplicationRequest request) {
        return this.put(request, ScaleApplicationResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "processes", request.getType(), "actions", "scale"})).checkpoint();
    }

    public Mono<SetApplicationCurrentDropletResponse> setCurrentDroplet(SetApplicationCurrentDropletRequest request) {
        return this.patch(request, SetApplicationCurrentDropletResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "relationships", "current_droplet"})).checkpoint();
    }

    public Mono<StartApplicationResponse> start(StartApplicationRequest request) {
        return this.post(request, StartApplicationResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "actions", "start"})).checkpoint();
    }

    public Mono<StopApplicationResponse> stop(StopApplicationRequest request) {
        return this.post(request, StopApplicationResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "actions", "stop"})).checkpoint();
    }

    public Mono<Void> terminateInstance(TerminateApplicationInstanceRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "processes", request.getType(), "instances", request.getIndex()})).checkpoint();
    }

    public Mono<UpdateApplicationResponse> update(UpdateApplicationRequest request) {
        return this.patch(request, UpdateApplicationResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId()})).checkpoint();
    }

    public Mono<UpdateApplicationEnvironmentVariablesResponse> updateEnvironmentVariables(UpdateApplicationEnvironmentVariablesRequest request) {
        return this.patch(request, UpdateApplicationEnvironmentVariablesResponse.class, builder -> builder.pathSegment(new String[]{"apps", request.getApplicationId(), "environment_variables"})).checkpoint();
    }
}

