/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa.serverinformation;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.util.AsciiString;
import java.util.Base64;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.uaa.AbstractUaaOperations;
import org.cloudfoundry.uaa.serverinformation.AutoLoginRequest;
import org.cloudfoundry.uaa.serverinformation.GetAutoLoginAuthenticationCodeRequest;
import org.cloudfoundry.uaa.serverinformation.GetAutoLoginAuthenticationCodeResponse;
import org.cloudfoundry.uaa.serverinformation.GetInfoRequest;
import org.cloudfoundry.uaa.serverinformation.GetInfoResponse;
import org.cloudfoundry.uaa.serverinformation.ServerInformation;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorServerInformation
extends AbstractUaaOperations
implements ServerInformation {
    private static final AsciiString BASIC_PREAMBLE = new AsciiString((CharSequence)"Basic ");

    public ReactorServerInformation(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<Void> autoLogin(AutoLoginRequest request) {
        return this.get((Object)request, Void.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"autologin"})).checkpoint();
    }

    public Mono<GetAutoLoginAuthenticationCodeResponse> getAuthenticationCode(GetAutoLoginAuthenticationCodeRequest request) {
        return this.post(request, GetAutoLoginAuthenticationCodeResponse.class, builder -> builder.pathSegment(new String[]{"autologin"}), outbound -> outbound.map(r -> {
            String encoded = Base64.getEncoder().encodeToString(new AsciiString((CharSequence)request.getClientId()).concat((CharSequence)":").concat((CharSequence)request.getClientSecret()).toByteArray());
            r.requestHeaders().set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)(BASIC_PREAMBLE + encoded));
            return r;
        })).checkpoint();
    }

    public Mono<GetInfoResponse> getInfo(GetInfoRequest request) {
        return this.get((Object)request, GetInfoResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"info"})).checkpoint();
    }
}

