package org.cloudfoundry.reactor;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Proxy configuration
 */
@Generated(from = "_ProxyConfiguration", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ProxyConfiguration extends org.cloudfoundry.reactor._ProxyConfiguration {
  private final String host;
  private final String password;
  private final Integer port;
  private final String username;

  private ProxyConfiguration(ProxyConfiguration.Builder builder) {
    this.host = builder.host;
    this.password = builder.password;
    this.port = builder.port;
    this.username = builder.username;
  }

  /**
   * The proxy host
   */
  @Override
  public String getHost() {
    return host;
  }

  /**
   * The proxy password
   */
  @Override
  public Optional<String> getPassword() {
    return Optional.ofNullable(password);
  }

  /**
   * The proxy port
   */
  @Override
  public Optional<Integer> getPort() {
    return Optional.ofNullable(port);
  }

  /**
   * The proxy username
   */
  @Override
  public Optional<String> getUsername() {
    return Optional.ofNullable(username);
  }

  /**
   * This instance is equal to all instances of {@code ProxyConfiguration} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ProxyConfiguration
        && equalTo((ProxyConfiguration) another);
  }

  private boolean equalTo(ProxyConfiguration another) {
    return host.equals(another.host)
        && Objects.equals(password, another.password)
        && Objects.equals(port, another.port)
        && Objects.equals(username, another.username);
  }

  /**
   * Computes a hash code from attributes: {@code host}, {@code password}, {@code port}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + host.hashCode();
    h += (h << 5) + Objects.hashCode(password);
    h += (h << 5) + Objects.hashCode(port);
    h += (h << 5) + Objects.hashCode(username);
    return h;
  }

  /**
   * Prints the immutable value {@code ProxyConfiguration} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ProxyConfiguration{");
    builder.append("host=").append(host);
    if (password != null) {
      builder.append(", ");
      builder.append("password=").append(password);
    }
    if (port != null) {
      builder.append(", ");
      builder.append("port=").append(port);
    }
    if (username != null) {
      builder.append(", ");
      builder.append("username=").append(username);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates a builder for {@link ProxyConfiguration ProxyConfiguration}.
   * @return A new ProxyConfiguration builder
   */
  public static ProxyConfiguration.Builder builder() {
    return new ProxyConfiguration.Builder();
  }

  /**
   * Builds instances of type {@link ProxyConfiguration ProxyConfiguration}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ProxyConfiguration", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_HOST = 0x1L;
    private long initBits = 0x1L;

    private String host;
    private String password;
    private Integer port;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProxyConfiguration} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProxyConfiguration instance) {
      return from((_ProxyConfiguration) instance);
    }

    /**
     * Copy abstract value type {@code _ProxyConfiguration} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ProxyConfiguration instance) {
      Objects.requireNonNull(instance, "instance");
      host(instance.getHost());
      Optional<String> passwordOptional = instance.getPassword();
      if (passwordOptional.isPresent()) {
        password(passwordOptional);
      }
      Optional<Integer> portOptional = instance.getPort();
      if (portOptional.isPresent()) {
        port(portOptional);
      }
      Optional<String> usernameOptional = instance.getUsername();
      if (usernameOptional.isPresent()) {
        username(usernameOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProxyConfiguration#getHost() host} attribute.
     * @param host The value for host 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder host(String host) {
      this.host = Objects.requireNonNull(host, "host");
      initBits &= ~INIT_BIT_HOST;
      return this;
    }

    /**
     * Initializes the optional value {@link ProxyConfiguration#getPassword() password} to password.
     * @param password The value for password
     * @return {@code this} builder for chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      return this;
    }

    /**
     * Initializes the optional value {@link ProxyConfiguration#getPassword() password} to password.
     * @param password The value for password
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(Optional<String> password) {
      this.password = password.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ProxyConfiguration#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(int port) {
      this.port = port;
      return this;
    }

    /**
     * Initializes the optional value {@link ProxyConfiguration#getPort() port} to port.
     * @param port The value for port
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder port(Optional<Integer> port) {
      this.port = port.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ProxyConfiguration#getUsername() username} to username.
     * @param username The value for username
     * @return {@code this} builder for chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      return this;
    }

    /**
     * Initializes the optional value {@link ProxyConfiguration#getUsername() username} to username.
     * @param username The value for username
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(Optional<String> username) {
      this.username = username.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ProxyConfiguration ProxyConfiguration}.
     * @return An immutable instance of ProxyConfiguration
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ProxyConfiguration build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ProxyConfiguration(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_HOST) != 0) attributes.add("host");
      return "Cannot build ProxyConfiguration, some of required attributes are not set " + attributes;
    }
  }
}
