package org.cloudfoundry.reactor.routing.v1.tcproutes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _ServerSentEvent}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ServerSentEvent.builder()}.
 */
@Generated(from = "_ServerSentEvent", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServerSentEvent extends org.cloudfoundry.reactor.routing.v1.tcproutes._ServerSentEvent {
  private transient final @Nullable String data;
  private final @Nullable List<String> datas;
  private final @Nullable String eventType;
  private final @Nullable String id;
  private final @Nullable Integer retry;

  private ServerSentEvent(ServerSentEvent.Builder builder) {
    this.datas = builder.datas == null ? null : createUnmodifiableList(true, builder.datas);
    this.eventType = builder.eventType;
    this.id = builder.id;
    this.retry = builder.retry;
    this.data = super.getData();
  }

  /**
   * @return The computed-at-construction value of the {@code data} attribute
   */
  @Override
  public @Nullable String getData() {
    return data;
  }

  /**
   * @return The value of the {@code datas} attribute
   */
  @Override
  public @Nullable List<String> getDatas() {
    return datas;
  }

  /**
   * @return The value of the {@code eventType} attribute
   */
  @Override
  public @Nullable String getEventType() {
    return eventType;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code retry} attribute
   */
  @Override
  public @Nullable Integer getRetry() {
    return retry;
  }

  /**
   * This instance is equal to all instances of {@code ServerSentEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServerSentEvent
        && equalTo((ServerSentEvent) another);
  }

  private boolean equalTo(ServerSentEvent another) {
    return Objects.equals(data, another.data)
        && Objects.equals(datas, another.datas)
        && Objects.equals(eventType, another.eventType)
        && Objects.equals(id, another.id)
        && Objects.equals(retry, another.retry);
  }

  /**
   * Computes a hash code from attributes: {@code data}, {@code datas}, {@code eventType}, {@code id}, {@code retry}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(data);
    h += (h << 5) + Objects.hashCode(datas);
    h += (h << 5) + Objects.hashCode(eventType);
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(retry);
    return h;
  }

  /**
   * Prints the immutable value {@code ServerSentEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServerSentEvent{"
        + "data=" + data
        + ", datas=" + datas
        + ", eventType=" + eventType
        + ", id=" + id
        + ", retry=" + retry
        + "}";
  }

  /**
   * Creates a builder for {@link ServerSentEvent ServerSentEvent}.
   * @return A new ServerSentEvent builder
   */
  public static ServerSentEvent.Builder builder() {
    return new ServerSentEvent.Builder();
  }

  /**
   * Builds instances of type {@link ServerSentEvent ServerSentEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServerSentEvent", generator = "Immutables")
  public static final class Builder {
    private List<String> datas = null;
    private String eventType;
    private String id;
    private Integer retry;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServerSentEvent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServerSentEvent instance) {
      return from((_ServerSentEvent) instance);
    }

    /**
     * Copy abstract value type {@code _ServerSentEvent} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServerSentEvent instance) {
      Objects.requireNonNull(instance, "instance");
      List<String> datasValue = instance.getDatas();
      if (datasValue != null) {
        addAllDatas(datasValue);
      }
      String eventTypeValue = instance.getEventType();
      if (eventTypeValue != null) {
        eventType(eventTypeValue);
      }
      String idValue = instance.getId();
      if (idValue != null) {
        id(idValue);
      }
      Integer retryValue = instance.getRetry();
      if (retryValue != null) {
        retry(retryValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link ServerSentEvent#getDatas() datas} list.
     * @param element A datas element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(String element) {
      if (this.datas == null) {
        this.datas = new ArrayList<String>();
      }
      this.datas.add(Objects.requireNonNull(element, "datas element"));
      return this;
    }

    /**
     * Adds elements to {@link ServerSentEvent#getDatas() datas} list.
     * @param elements An array of datas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datas(String... elements) {
      if (this.datas == null) {
        this.datas = new ArrayList<String>();
      }
      for (String element : elements) {
        this.datas.add(Objects.requireNonNull(element, "datas element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ServerSentEvent#getDatas() datas} list.
     * @param elements An iterable of datas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder datas(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.datas = null;
        return this;
      }
      this.datas = new ArrayList<String>();
      return addAllDatas(elements);
    }

    /**
     * Adds elements to {@link ServerSentEvent#getDatas() datas} list.
     * @param elements An iterable of datas elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDatas(Iterable<String> elements) {
      Objects.requireNonNull(elements, "datas element");
      if (this.datas == null) {
        this.datas = new ArrayList<String>();
      }
      for (String element : elements) {
        this.datas.add(Objects.requireNonNull(element, "datas element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ServerSentEvent#getEventType() eventType} attribute.
     * @param eventType The value for eventType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder eventType(@Nullable String eventType) {
      this.eventType = eventType;
      return this;
    }

    /**
     * Initializes the value for the {@link ServerSentEvent#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link ServerSentEvent#getRetry() retry} attribute.
     * @param retry The value for retry (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder retry(@Nullable Integer retry) {
      this.retry = retry;
      return this;
    }

    /**
     * Builds a new {@link ServerSentEvent ServerSentEvent}.
     * @return An immutable instance of ServerSentEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServerSentEvent build() {
      return new ServerSentEvent(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
