package org.cloudfoundry.reactor.tokenprovider;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The OAuth Password Grant implementation of {@link TokenProvider}
 */
@Generated(from = "_PasswordGrantTokenProvider", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class PasswordGrantTokenProvider
    extends org.cloudfoundry.reactor.tokenprovider._PasswordGrantTokenProvider {
  private final @Nullable String loginHint;
  private final String password;
  private final String username;
  private final String clientId;
  private final String clientSecret;
  private final @Nullable String identityZoneSubdomain;

  private PasswordGrantTokenProvider(PasswordGrantTokenProvider.Builder builder) {
    this.loginHint = builder.loginHint;
    this.password = builder.password;
    this.username = builder.username;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
    if (builder.clientId != null) {
      initShim.clientId(builder.clientId);
    }
    if (builder.clientSecret != null) {
      initShim.clientSecret(builder.clientSecret);
    }
    this.clientId = initShim.getClientId();
    this.clientSecret = initShim.getClientSecret();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "_PasswordGrantTokenProvider", generator = "Immutables")
  private final class InitShim {
    private byte clientIdBuildStage = STAGE_UNINITIALIZED;
    private String clientId;

    String getClientId() {
      if (clientIdBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientIdBuildStage == STAGE_UNINITIALIZED) {
        clientIdBuildStage = STAGE_INITIALIZING;
        this.clientId = Objects.requireNonNull(PasswordGrantTokenProvider.super.getClientId(), "clientId");
        clientIdBuildStage = STAGE_INITIALIZED;
      }
      return this.clientId;
    }

    void clientId(String clientId) {
      this.clientId = clientId;
      clientIdBuildStage = STAGE_INITIALIZED;
    }

    private byte clientSecretBuildStage = STAGE_UNINITIALIZED;
    private String clientSecret;

    String getClientSecret() {
      if (clientSecretBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (clientSecretBuildStage == STAGE_UNINITIALIZED) {
        clientSecretBuildStage = STAGE_INITIALIZING;
        this.clientSecret = Objects.requireNonNull(PasswordGrantTokenProvider.super.getClientSecret(), "clientSecret");
        clientSecretBuildStage = STAGE_INITIALIZED;
      }
      return this.clientSecret;
    }

    void clientSecret(String clientSecret) {
      this.clientSecret = clientSecret;
      clientSecretBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (clientIdBuildStage == STAGE_INITIALIZING) attributes.add("clientId");
      if (clientSecretBuildStage == STAGE_INITIALIZING) attributes.add("clientSecret");
      return "Cannot build PasswordGrantTokenProvider, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * The login hint
   */
  @Override
  public @Nullable String getLoginHint() {
    return loginHint;
  }

  /**
   * The password
   */
  @Override
  public String getPassword() {
    return password;
  }

  /**
   * The username
   */
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * The client id. Defaults to {@code cf}.
   */
  @Override
  public String getClientId() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getClientId()
        : this.clientId;
  }

  /**
   * The client secret. Defaults to {@code ""}.
   */
  @Override
  public String getClientSecret() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getClientSecret()
        : this.clientSecret;
  }

  /**
   * The identity zone subdomain
   */
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * This instance is equal to all instances of {@code PasswordGrantTokenProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof PasswordGrantTokenProvider
        && equalTo((PasswordGrantTokenProvider) another);
  }

  private boolean equalTo(PasswordGrantTokenProvider another) {
    return Objects.equals(loginHint, another.loginHint)
        && password.equals(another.password)
        && username.equals(another.username)
        && clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain);
  }

  /**
   * Computes a hash code from attributes: {@code loginHint}, {@code password}, {@code username}, {@code clientId}, {@code clientSecret}, {@code identityZoneSubdomain}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(loginHint);
    h += (h << 5) + password.hashCode();
    h += (h << 5) + username.hashCode();
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + clientSecret.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    return h;
  }

  /**
   * Prints the immutable value {@code PasswordGrantTokenProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PasswordGrantTokenProvider{"
        + "loginHint=" + loginHint
        + ", password=" + password
        + ", username=" + username
        + ", clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + "}";
  }

  /**
   * Creates a builder for {@link PasswordGrantTokenProvider PasswordGrantTokenProvider}.
   * @return A new PasswordGrantTokenProvider builder
   */
  public static PasswordGrantTokenProvider.Builder builder() {
    return new PasswordGrantTokenProvider.Builder();
  }

  /**
   * Builds instances of type {@link PasswordGrantTokenProvider PasswordGrantTokenProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_PasswordGrantTokenProvider", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PASSWORD = 0x1L;
    private static final long INIT_BIT_USERNAME = 0x2L;
    private long initBits = 0x3L;

    private String loginHint;
    private String password;
    private String username;
    private String clientId;
    private String clientSecret;
    private String identityZoneSubdomain;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PasswordGrantTokenProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PasswordGrantTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _PasswordGrantTokenProvider} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_PasswordGrantTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.reactor.tokenprovider.AbstractUaaTokenProvider} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractUaaTokenProvider instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.reactor.tokenprovider._PasswordGrantTokenProvider) {
        org.cloudfoundry.reactor.tokenprovider._PasswordGrantTokenProvider instance = (org.cloudfoundry.reactor.tokenprovider._PasswordGrantTokenProvider) object;
        String loginHintValue = instance.getLoginHint();
        if (loginHintValue != null) {
          loginHint(loginHintValue);
        }
        password(instance.getPassword());
        username(instance.getUsername());
      }
      if (object instanceof AbstractUaaTokenProvider) {
        AbstractUaaTokenProvider instance = (AbstractUaaTokenProvider) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        clientSecret(instance.getClientSecret());
        clientId(instance.getClientId());
      }
    }

    /**
     * Initializes the value for the {@link PasswordGrantTokenProvider#getLoginHint() loginHint} attribute.
     * @param loginHint The value for loginHint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder loginHint(@Nullable String loginHint) {
      this.loginHint = loginHint;
      return this;
    }

    /**
     * Initializes the value for the {@link PasswordGrantTokenProvider#getPassword() password} attribute.
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      initBits &= ~INIT_BIT_PASSWORD;
      return this;
    }

    /**
     * Initializes the value for the {@link PasswordGrantTokenProvider#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Initializes the value for the {@link PasswordGrantTokenProvider#getClientId() clientId} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PasswordGrantTokenProvider#getClientId() clientId}.</em>
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      return this;
    }

    /**
     * Initializes the value for the {@link PasswordGrantTokenProvider#getClientSecret() clientSecret} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link PasswordGrantTokenProvider#getClientSecret() clientSecret}.</em>
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      return this;
    }

    /**
     * Initializes the value for the {@link PasswordGrantTokenProvider#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Builds a new {@link PasswordGrantTokenProvider PasswordGrantTokenProvider}.
     * @return An immutable instance of PasswordGrantTokenProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PasswordGrantTokenProvider build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new PasswordGrantTokenProvider(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PASSWORD) != 0) attributes.add("password");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build PasswordGrantTokenProvider, some of required attributes are not set " + attributes;
    }
  }
}
