/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.json.JsonObjectDecoder;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.cloudfoundry.reactor.util.AnnotationUtils;
import org.cloudfoundry.reactor.util.JsonParsingException;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClientRequest;
import reactor.ipc.netty.http.client.HttpClientResponse;

public final class JsonCodec {
    private static final int MAX_PAYLOAD_SIZE = 0x6400000;

    public static HttpClientRequest addDecodeHeaders(HttpClientRequest request) {
        return request.header((CharSequence)HttpHeaderNames.ACCEPT, (CharSequence)HttpHeaderValues.APPLICATION_JSON);
    }

    public static <T> Function<Mono<HttpClientResponse>, Flux<T>> decode(ObjectMapper objectMapper, Class<T> responseType) {
        return inbound -> inbound.flatMapMany(response -> response.addHandler((ChannelHandler)new JsonObjectDecoder(0x6400000)).receive().asByteArray().map(payload -> {
            try {
                return objectMapper.readValue(payload, responseType);
            }
            catch (Throwable t) {
                throw new JsonParsingException(t.getMessage(), t, new String((byte[])payload, Charset.defaultCharset()));
            }
        }));
    }

    static Function<Mono<HttpClientRequest>, Publisher<Void>> encode(ObjectMapper objectMapper, Object requestPayload) {
        if (!AnnotationUtils.findAnnotation(requestPayload.getClass(), JsonSerialize.class).isPresent()) {
            return outbound -> outbound.flatMap(HttpClientRequest::send);
        }
        return outbound -> outbound.flatMapMany(request -> {
            try {
                byte[] bytes = objectMapper.writeValueAsBytes(requestPayload);
                return request.header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)HttpHeaderValues.APPLICATION_JSON).header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)String.valueOf(bytes.length)).sendByteArray((Publisher)Mono.just((Object)bytes));
            }
            catch (JsonProcessingException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        });
    }
}

