/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import io.netty.bootstrap.Bootstrap;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Optional;
import reactor.ipc.netty.http.client.HttpClient;
import reactor.ipc.netty.http.client.HttpClientRequest;

public final class UserAgent {
    public static final String USER_AGENT = String.format("CloudFoundryJavaClient/%s (Java; %s/%s) ReactorNetty/%s (Netty/%s)", UserAgent.javaClientVersion(), UserAgent.javaVendor(), UserAgent.javaVersion(), UserAgent.reactorNettyVersion(), UserAgent.nettyVersion());

    private UserAgent() {
    }

    public static HttpClientRequest addUserAgent(HttpClientRequest request) {
        return request.header((CharSequence)HttpHeaderNames.USER_AGENT, (CharSequence)USER_AGENT);
    }

    private static String javaClientVersion() {
        return Optional.ofNullable(UserAgent.class.getPackage().getImplementationVersion()).orElse("unknown");
    }

    private static String javaVendor() {
        return Optional.ofNullable(System.getProperty("java.vendor")).orElse("unknown");
    }

    private static String javaVersion() {
        return Optional.ofNullable(System.getProperty("java.version")).orElse("unknown");
    }

    private static String nettyVersion() {
        return Optional.ofNullable(Bootstrap.class.getPackage().getImplementationVersion()).orElse("unknown");
    }

    private static String reactorNettyVersion() {
        return Optional.ofNullable(HttpClient.class.getPackage().getImplementationVersion()).orElse("unknown");
    }
}

