/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.ProxyConfiguration;
import org.cloudfoundry.reactor.RootProvider;
import org.cloudfoundry.reactor._DefaultConnectionContext;
import org.cloudfoundry.reactor.util.SslCertificateTruster;
import org.immutables.value.Generated;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;

@Generated(from="_DefaultConnectionContext", generator="Immutables")
public final class DefaultConnectionContext
extends _DefaultConnectionContext {
    private final Duration cacheDuration;
    @Nullable
    private final Integer connectionPoolSize;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final RootProvider rootProvider;
    private final Integer threadPoolSize;
    private final String apiHost;
    private final Duration connectTimeout;
    private final transient Optional<ConnectionProvider> connectionProvider;
    private final Boolean keepAlive;
    private final Integer port;
    private final List<DeserializationProblemHandler> problemHandlers;
    private final ProxyConfiguration proxyConfiguration;
    private final Boolean secure;
    private final Boolean skipSslValidation;
    private final transient Optional<SslCertificateTruster> sslCertificateTruster;
    private final Duration sslCloseNotifyFlushTimeout;
    private final Duration sslCloseNotifyReadTimeout;
    private final Duration sslHandshakeTimeout;
    private final transient LoopResources threadPool;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private DefaultConnectionContext(Builder builder) {
        this.cacheDuration = builder.cacheDuration;
        this.apiHost = builder.apiHost;
        this.connectTimeout = builder.connectTimeout;
        this.keepAlive = builder.keepAlive;
        this.port = builder.port;
        this.problemHandlers = DefaultConnectionContext.createUnmodifiableList(true, builder.problemHandlers);
        this.proxyConfiguration = builder.proxyConfiguration;
        this.secure = builder.secure;
        this.skipSslValidation = builder.skipSslValidation;
        this.sslCloseNotifyFlushTimeout = builder.sslCloseNotifyFlushTimeout;
        this.sslCloseNotifyReadTimeout = builder.sslCloseNotifyReadTimeout;
        this.sslHandshakeTimeout = builder.sslHandshakeTimeout;
        if (builder.connectionPoolSizeIsSet()) {
            this.initShim.connectionPoolSize(builder.connectionPoolSize);
        }
        if (builder.httpClient != null) {
            this.initShim.httpClient(builder.httpClient);
        }
        if (builder.objectMapper != null) {
            this.initShim.objectMapper(builder.objectMapper);
        }
        if (builder.rootProvider != null) {
            this.initShim.rootProvider(builder.rootProvider);
        }
        if (builder.threadPoolSize != null) {
            this.initShim.threadPoolSize(builder.threadPoolSize);
        }
        this.connectionPoolSize = this.initShim.getConnectionPoolSize();
        this.httpClient = this.initShim.getHttpClient();
        this.objectMapper = this.initShim.getObjectMapper();
        this.rootProvider = this.initShim.getRootProvider();
        this.threadPoolSize = this.initShim.getThreadPoolSize();
        this.connectionProvider = this.initShim.getConnectionProvider();
        this.sslCertificateTruster = this.initShim.getSslCertificateTruster();
        this.threadPool = this.initShim.getThreadPool();
        this.initShim = null;
    }

    @Override
    public Optional<Duration> getCacheDuration() {
        return Optional.ofNullable(this.cacheDuration);
    }

    @Override
    @Nullable
    public Integer getConnectionPoolSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getConnectionPoolSize() : this.connectionPoolSize;
    }

    @Override
    public HttpClient getHttpClient() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getHttpClient() : this.httpClient;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObjectMapper() : this.objectMapper;
    }

    @Override
    public RootProvider getRootProvider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRootProvider() : this.rootProvider;
    }

    @Override
    public Integer getThreadPoolSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getThreadPoolSize() : this.threadPoolSize;
    }

    @Override
    public String getApiHost() {
        return this.apiHost;
    }

    @Override
    public Optional<Duration> getConnectTimeout() {
        return Optional.ofNullable(this.connectTimeout);
    }

    @Override
    public Optional<ConnectionProvider> getConnectionProvider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getConnectionProvider() : this.connectionProvider;
    }

    @Override
    public Optional<Boolean> getKeepAlive() {
        return Optional.ofNullable(this.keepAlive);
    }

    @Override
    public Optional<Integer> getPort() {
        return Optional.ofNullable(this.port);
    }

    @Override
    public List<DeserializationProblemHandler> getProblemHandlers() {
        return this.problemHandlers;
    }

    @Override
    public Optional<ProxyConfiguration> getProxyConfiguration() {
        return Optional.ofNullable(this.proxyConfiguration);
    }

    @Override
    public Optional<Boolean> getSecure() {
        return Optional.ofNullable(this.secure);
    }

    @Override
    public Optional<Boolean> getSkipSslValidation() {
        return Optional.ofNullable(this.skipSslValidation);
    }

    @Override
    public Optional<SslCertificateTruster> getSslCertificateTruster() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSslCertificateTruster() : this.sslCertificateTruster;
    }

    @Override
    public Optional<Duration> getSslCloseNotifyFlushTimeout() {
        return Optional.ofNullable(this.sslCloseNotifyFlushTimeout);
    }

    @Override
    public Optional<Duration> getSslCloseNotifyReadTimeout() {
        return Optional.ofNullable(this.sslCloseNotifyReadTimeout);
    }

    @Override
    public Optional<Duration> getSslHandshakeTimeout() {
        return Optional.ofNullable(this.sslHandshakeTimeout);
    }

    @Override
    public LoopResources getThreadPool() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getThreadPool() : this.threadPool;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DefaultConnectionContext && this.equalTo((DefaultConnectionContext)another);
    }

    private boolean equalTo(DefaultConnectionContext another) {
        return Objects.equals(this.cacheDuration, another.cacheDuration) && Objects.equals(this.connectionPoolSize, another.connectionPoolSize) && this.httpClient.equals(another.httpClient) && this.objectMapper.equals(another.objectMapper) && this.rootProvider.equals(another.rootProvider) && this.threadPoolSize.equals(another.threadPoolSize) && this.apiHost.equals(another.apiHost) && Objects.equals(this.connectTimeout, another.connectTimeout) && this.connectionProvider.equals(another.connectionProvider) && Objects.equals(this.keepAlive, another.keepAlive) && Objects.equals(this.port, another.port) && this.problemHandlers.equals(another.problemHandlers) && Objects.equals(this.proxyConfiguration, another.proxyConfiguration) && Objects.equals(this.secure, another.secure) && Objects.equals(this.skipSslValidation, another.skipSslValidation) && this.sslCertificateTruster.equals(another.sslCertificateTruster) && Objects.equals(this.sslCloseNotifyFlushTimeout, another.sslCloseNotifyFlushTimeout) && Objects.equals(this.sslCloseNotifyReadTimeout, another.sslCloseNotifyReadTimeout) && Objects.equals(this.sslHandshakeTimeout, another.sslHandshakeTimeout) && this.threadPool.equals(another.threadPool);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.cacheDuration);
        h += (h << 5) + Objects.hashCode(this.connectionPoolSize);
        h += (h << 5) + this.httpClient.hashCode();
        h += (h << 5) + this.objectMapper.hashCode();
        h += (h << 5) + this.rootProvider.hashCode();
        h += (h << 5) + this.threadPoolSize.hashCode();
        h += (h << 5) + this.apiHost.hashCode();
        h += (h << 5) + Objects.hashCode(this.connectTimeout);
        h += (h << 5) + this.connectionProvider.hashCode();
        h += (h << 5) + Objects.hashCode(this.keepAlive);
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + this.problemHandlers.hashCode();
        h += (h << 5) + Objects.hashCode(this.proxyConfiguration);
        h += (h << 5) + Objects.hashCode(this.secure);
        h += (h << 5) + Objects.hashCode(this.skipSslValidation);
        h += (h << 5) + this.sslCertificateTruster.hashCode();
        h += (h << 5) + Objects.hashCode(this.sslCloseNotifyFlushTimeout);
        h += (h << 5) + Objects.hashCode(this.sslCloseNotifyReadTimeout);
        h += (h << 5) + Objects.hashCode(this.sslHandshakeTimeout);
        h += (h << 5) + this.threadPool.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DefaultConnectionContext{");
        if (this.cacheDuration != null) {
            builder.append("cacheDuration=").append(this.cacheDuration);
        }
        if (this.connectionPoolSize != null) {
            if (builder.length() > 25) {
                builder.append(", ");
            }
            builder.append("connectionPoolSize=").append(this.connectionPoolSize);
        }
        if (builder.length() > 25) {
            builder.append(", ");
        }
        builder.append("httpClient=").append(this.httpClient);
        builder.append(", ");
        builder.append("objectMapper=").append(this.objectMapper);
        builder.append(", ");
        builder.append("rootProvider=").append(this.rootProvider);
        builder.append(", ");
        builder.append("threadPoolSize=").append(this.threadPoolSize);
        builder.append(", ");
        builder.append("apiHost=").append(this.apiHost);
        if (this.connectTimeout != null) {
            builder.append(", ");
            builder.append("connectTimeout=").append(this.connectTimeout);
        }
        builder.append(", ");
        builder.append("connectionProvider=").append(this.connectionProvider);
        if (this.keepAlive != null) {
            builder.append(", ");
            builder.append("keepAlive=").append(this.keepAlive);
        }
        if (this.port != null) {
            builder.append(", ");
            builder.append("port=").append(this.port);
        }
        builder.append(", ");
        builder.append("problemHandlers=").append(this.problemHandlers);
        if (this.proxyConfiguration != null) {
            builder.append(", ");
            builder.append("proxyConfiguration=").append(this.proxyConfiguration);
        }
        if (this.secure != null) {
            builder.append(", ");
            builder.append("secure=").append(this.secure);
        }
        if (this.skipSslValidation != null) {
            builder.append(", ");
            builder.append("skipSslValidation=").append(this.skipSslValidation);
        }
        builder.append(", ");
        builder.append("sslCertificateTruster=").append(this.sslCertificateTruster);
        if (this.sslCloseNotifyFlushTimeout != null) {
            builder.append(", ");
            builder.append("sslCloseNotifyFlushTimeout=").append(this.sslCloseNotifyFlushTimeout);
        }
        if (this.sslCloseNotifyReadTimeout != null) {
            builder.append(", ");
            builder.append("sslCloseNotifyReadTimeout=").append(this.sslCloseNotifyReadTimeout);
        }
        if (this.sslHandshakeTimeout != null) {
            builder.append(", ");
            builder.append("sslHandshakeTimeout=").append(this.sslHandshakeTimeout);
        }
        builder.append(", ");
        builder.append("threadPool=").append(this.threadPool);
        return builder.append("}").toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_DefaultConnectionContext", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_API_HOST = 1L;
        private static final long OPT_BIT_CONNECTION_POOL_SIZE = 1L;
        private long initBits = 1L;
        private long optBits;
        private Duration cacheDuration;
        private Integer connectionPoolSize;
        private HttpClient httpClient;
        private ObjectMapper objectMapper;
        private RootProvider rootProvider;
        private Integer threadPoolSize;
        private String apiHost;
        private Duration connectTimeout;
        private Boolean keepAlive;
        private Integer port;
        private List<DeserializationProblemHandler> problemHandlers = new ArrayList<DeserializationProblemHandler>();
        private ProxyConfiguration proxyConfiguration;
        private Boolean secure;
        private Boolean skipSslValidation;
        private Duration sslCloseNotifyFlushTimeout;
        private Duration sslCloseNotifyReadTimeout;
        private Duration sslHandshakeTimeout;

        private Builder() {
        }

        public final Builder from(DefaultConnectionContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_DefaultConnectionContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConnectionContext instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ConnectionContext instance;
            long bits = 0L;
            if (object instanceof _DefaultConnectionContext) {
                Optional<ProxyConfiguration> proxyConfigurationOptional;
                Optional<Duration> connectTimeoutOptional;
                Optional<Duration> sslHandshakeTimeoutOptional;
                Optional<Duration> sslCloseNotifyFlushTimeoutOptional;
                Optional<Boolean> skipSslValidationOptional;
                Optional<Boolean> secureOptional;
                Optional<Boolean> keepAliveOptional;
                Optional<Duration> sslCloseNotifyReadTimeoutOptional;
                instance = (_DefaultConnectionContext)object;
                if ((bits & 1L) == 0L) {
                    this.httpClient(((_DefaultConnectionContext)instance).getHttpClient());
                    bits |= 1L;
                }
                if ((sslCloseNotifyReadTimeoutOptional = ((_DefaultConnectionContext)instance).getSslCloseNotifyReadTimeout()).isPresent()) {
                    this.sslCloseNotifyReadTimeout(sslCloseNotifyReadTimeoutOptional);
                }
                if ((keepAliveOptional = ((_DefaultConnectionContext)instance).getKeepAlive()).isPresent()) {
                    this.keepAlive(keepAliveOptional);
                }
                this.apiHost(((_DefaultConnectionContext)instance).getApiHost());
                Integer connectionPoolSizeValue = ((_DefaultConnectionContext)instance).getConnectionPoolSize();
                if (connectionPoolSizeValue != null) {
                    this.connectionPoolSize(connectionPoolSizeValue);
                }
                if ((secureOptional = ((_DefaultConnectionContext)instance).getSecure()).isPresent()) {
                    this.secure(secureOptional);
                }
                if ((skipSslValidationOptional = ((_DefaultConnectionContext)instance).getSkipSslValidation()).isPresent()) {
                    this.skipSslValidation(skipSslValidationOptional);
                }
                this.addAllProblemHandlers(((_DefaultConnectionContext)instance).getProblemHandlers());
                if ((bits & 2L) == 0L) {
                    this.rootProvider(((_DefaultConnectionContext)instance).getRootProvider());
                    bits |= 2L;
                }
                if ((sslCloseNotifyFlushTimeoutOptional = ((_DefaultConnectionContext)instance).getSslCloseNotifyFlushTimeout()).isPresent()) {
                    this.sslCloseNotifyFlushTimeout(sslCloseNotifyFlushTimeoutOptional);
                }
                if ((bits & 4L) == 0L) {
                    this.objectMapper(((_DefaultConnectionContext)instance).getObjectMapper());
                    bits |= 4L;
                }
                this.threadPoolSize(((_DefaultConnectionContext)instance).getThreadPoolSize());
                Optional<Integer> portOptional = ((_DefaultConnectionContext)instance).getPort();
                if (portOptional.isPresent()) {
                    this.port(portOptional);
                }
                if ((sslHandshakeTimeoutOptional = ((_DefaultConnectionContext)instance).getSslHandshakeTimeout()).isPresent()) {
                    this.sslHandshakeTimeout(sslHandshakeTimeoutOptional);
                }
                if ((bits & 8L) == 0L) {
                    Optional<Duration> cacheDurationOptional = ((_DefaultConnectionContext)instance).getCacheDuration();
                    if (cacheDurationOptional.isPresent()) {
                        this.cacheDuration(cacheDurationOptional);
                    }
                    bits |= 8L;
                }
                if ((connectTimeoutOptional = ((_DefaultConnectionContext)instance).getConnectTimeout()).isPresent()) {
                    this.connectTimeout(connectTimeoutOptional);
                }
                if ((proxyConfigurationOptional = ((_DefaultConnectionContext)instance).getProxyConfiguration()).isPresent()) {
                    this.proxyConfiguration(proxyConfigurationOptional);
                }
            }
            if (object instanceof ConnectionContext) {
                instance = (ConnectionContext)object;
                if ((bits & 1L) == 0L) {
                    this.httpClient(instance.getHttpClient());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.objectMapper(instance.getObjectMapper());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.rootProvider(instance.getRootProvider());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    Optional<Duration> cacheDurationOptional = instance.getCacheDuration();
                    if (cacheDurationOptional.isPresent()) {
                        this.cacheDuration(cacheDurationOptional);
                    }
                    bits |= 8L;
                }
            }
        }

        public final Builder cacheDuration(Duration cacheDuration) {
            this.cacheDuration = Objects.requireNonNull(cacheDuration, "cacheDuration");
            return this;
        }

        public final Builder cacheDuration(Optional<? extends Duration> cacheDuration) {
            this.cacheDuration = cacheDuration.orElse(null);
            return this;
        }

        public final Builder connectionPoolSize(@Nullable Integer connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
            this.optBits |= 1L;
            return this;
        }

        public final Builder httpClient(HttpClient httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "httpClient");
            return this;
        }

        public final Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            return this;
        }

        public final Builder rootProvider(RootProvider rootProvider) {
            this.rootProvider = Objects.requireNonNull(rootProvider, "rootProvider");
            return this;
        }

        public final Builder threadPoolSize(Integer threadPoolSize) {
            this.threadPoolSize = Objects.requireNonNull(threadPoolSize, "threadPoolSize");
            return this;
        }

        public final Builder apiHost(String apiHost) {
            this.apiHost = Objects.requireNonNull(apiHost, "apiHost");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = Objects.requireNonNull(connectTimeout, "connectTimeout");
            return this;
        }

        public final Builder connectTimeout(Optional<? extends Duration> connectTimeout) {
            this.connectTimeout = connectTimeout.orElse(null);
            return this;
        }

        public final Builder keepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public final Builder keepAlive(Optional<Boolean> keepAlive) {
            this.keepAlive = keepAlive.orElse(null);
            return this;
        }

        public final Builder port(int port) {
            this.port = port;
            return this;
        }

        public final Builder port(Optional<Integer> port) {
            this.port = port.orElse(null);
            return this;
        }

        public final Builder problemHandler(DeserializationProblemHandler element) {
            this.problemHandlers.add(Objects.requireNonNull(element, "problemHandlers element"));
            return this;
        }

        public final Builder problemHandlers(DeserializationProblemHandler ... elements) {
            for (DeserializationProblemHandler element : elements) {
                this.problemHandlers.add(Objects.requireNonNull(element, "problemHandlers element"));
            }
            return this;
        }

        public final Builder problemHandlers(Iterable<? extends DeserializationProblemHandler> elements) {
            this.problemHandlers.clear();
            return this.addAllProblemHandlers(elements);
        }

        public final Builder addAllProblemHandlers(Iterable<? extends DeserializationProblemHandler> elements) {
            for (DeserializationProblemHandler deserializationProblemHandler : elements) {
                this.problemHandlers.add(Objects.requireNonNull(deserializationProblemHandler, "problemHandlers element"));
            }
            return this;
        }

        public final Builder proxyConfiguration(ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = Objects.requireNonNull(proxyConfiguration, "proxyConfiguration");
            return this;
        }

        public final Builder proxyConfiguration(Optional<? extends ProxyConfiguration> proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration.orElse(null);
            return this;
        }

        public final Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public final Builder secure(Optional<Boolean> secure) {
            this.secure = secure.orElse(null);
            return this;
        }

        public final Builder skipSslValidation(boolean skipSslValidation) {
            this.skipSslValidation = skipSslValidation;
            return this;
        }

        public final Builder skipSslValidation(Optional<Boolean> skipSslValidation) {
            this.skipSslValidation = skipSslValidation.orElse(null);
            return this;
        }

        public final Builder sslCloseNotifyFlushTimeout(Duration sslCloseNotifyFlushTimeout) {
            this.sslCloseNotifyFlushTimeout = Objects.requireNonNull(sslCloseNotifyFlushTimeout, "sslCloseNotifyFlushTimeout");
            return this;
        }

        public final Builder sslCloseNotifyFlushTimeout(Optional<? extends Duration> sslCloseNotifyFlushTimeout) {
            this.sslCloseNotifyFlushTimeout = sslCloseNotifyFlushTimeout.orElse(null);
            return this;
        }

        public final Builder sslCloseNotifyReadTimeout(Duration sslCloseNotifyReadTimeout) {
            this.sslCloseNotifyReadTimeout = Objects.requireNonNull(sslCloseNotifyReadTimeout, "sslCloseNotifyReadTimeout");
            return this;
        }

        public final Builder sslCloseNotifyReadTimeout(Optional<? extends Duration> sslCloseNotifyReadTimeout) {
            this.sslCloseNotifyReadTimeout = sslCloseNotifyReadTimeout.orElse(null);
            return this;
        }

        public final Builder sslHandshakeTimeout(Duration sslHandshakeTimeout) {
            this.sslHandshakeTimeout = Objects.requireNonNull(sslHandshakeTimeout, "sslHandshakeTimeout");
            return this;
        }

        public final Builder sslHandshakeTimeout(Optional<? extends Duration> sslHandshakeTimeout) {
            this.sslHandshakeTimeout = sslHandshakeTimeout.orElse(null);
            return this;
        }

        public DefaultConnectionContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new DefaultConnectionContext(this);
        }

        private boolean connectionPoolSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("apiHost");
            }
            return "Cannot build DefaultConnectionContext, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="_DefaultConnectionContext", generator="Immutables")
    private final class InitShim {
        private byte connectionPoolSizeBuildStage = 0;
        private Integer connectionPoolSize;
        private byte httpClientBuildStage = 0;
        private HttpClient httpClient;
        private byte objectMapperBuildStage = 0;
        private ObjectMapper objectMapper;
        private byte rootProviderBuildStage = 0;
        private RootProvider rootProvider;
        private byte threadPoolSizeBuildStage = 0;
        private Integer threadPoolSize;
        private byte connectionProviderBuildStage = 0;
        private Optional<ConnectionProvider> connectionProvider;
        private byte sslCertificateTrusterBuildStage = 0;
        private Optional<SslCertificateTruster> sslCertificateTruster;
        private byte threadPoolBuildStage = 0;
        private LoopResources threadPool;

        private InitShim() {
        }

        Integer getConnectionPoolSize() {
            if (this.connectionPoolSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.connectionPoolSizeBuildStage == 0) {
                this.connectionPoolSizeBuildStage = (byte)-1;
                this.connectionPoolSize = DefaultConnectionContext.super.getConnectionPoolSize();
                this.connectionPoolSizeBuildStage = 1;
            }
            return this.connectionPoolSize;
        }

        void connectionPoolSize(Integer connectionPoolSize) {
            this.connectionPoolSize = connectionPoolSize;
            this.connectionPoolSizeBuildStage = 1;
        }

        HttpClient getHttpClient() {
            if (this.httpClientBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.httpClientBuildStage == 0) {
                this.httpClientBuildStage = (byte)-1;
                this.httpClient = Objects.requireNonNull(DefaultConnectionContext.super.getHttpClient(), "httpClient");
                this.httpClientBuildStage = 1;
            }
            return this.httpClient;
        }

        void httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            this.httpClientBuildStage = 1;
        }

        ObjectMapper getObjectMapper() {
            if (this.objectMapperBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMapperBuildStage == 0) {
                this.objectMapperBuildStage = (byte)-1;
                this.objectMapper = Objects.requireNonNull(DefaultConnectionContext.super.getObjectMapper(), "objectMapper");
                this.objectMapperBuildStage = 1;
            }
            return this.objectMapper;
        }

        void objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            this.objectMapperBuildStage = 1;
        }

        RootProvider getRootProvider() {
            if (this.rootProviderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rootProviderBuildStage == 0) {
                this.rootProviderBuildStage = (byte)-1;
                this.rootProvider = Objects.requireNonNull(DefaultConnectionContext.super.getRootProvider(), "rootProvider");
                this.rootProviderBuildStage = 1;
            }
            return this.rootProvider;
        }

        void rootProvider(RootProvider rootProvider) {
            this.rootProvider = rootProvider;
            this.rootProviderBuildStage = 1;
        }

        Integer getThreadPoolSize() {
            if (this.threadPoolSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.threadPoolSizeBuildStage == 0) {
                this.threadPoolSizeBuildStage = (byte)-1;
                this.threadPoolSize = Objects.requireNonNull(DefaultConnectionContext.super.getThreadPoolSize(), "threadPoolSize");
                this.threadPoolSizeBuildStage = 1;
            }
            return this.threadPoolSize;
        }

        void threadPoolSize(Integer threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
            this.threadPoolSizeBuildStage = 1;
        }

        Optional<ConnectionProvider> getConnectionProvider() {
            if (this.connectionProviderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.connectionProviderBuildStage == 0) {
                this.connectionProviderBuildStage = (byte)-1;
                this.connectionProvider = Objects.requireNonNull(DefaultConnectionContext.super.getConnectionProvider(), "connectionProvider");
                this.connectionProviderBuildStage = 1;
            }
            return this.connectionProvider;
        }

        Optional<SslCertificateTruster> getSslCertificateTruster() {
            if (this.sslCertificateTrusterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sslCertificateTrusterBuildStage == 0) {
                this.sslCertificateTrusterBuildStage = (byte)-1;
                this.sslCertificateTruster = Objects.requireNonNull(DefaultConnectionContext.super.getSslCertificateTruster(), "sslCertificateTruster");
                this.sslCertificateTrusterBuildStage = 1;
            }
            return this.sslCertificateTruster;
        }

        LoopResources getThreadPool() {
            if (this.threadPoolBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.threadPoolBuildStage == 0) {
                this.threadPoolBuildStage = (byte)-1;
                this.threadPool = Objects.requireNonNull(DefaultConnectionContext.super.getThreadPool(), "threadPool");
                this.threadPoolBuildStage = 1;
            }
            return this.threadPool;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.connectionPoolSizeBuildStage == -1) {
                attributes.add("connectionPoolSize");
            }
            if (this.httpClientBuildStage == -1) {
                attributes.add("httpClient");
            }
            if (this.objectMapperBuildStage == -1) {
                attributes.add("objectMapper");
            }
            if (this.rootProviderBuildStage == -1) {
                attributes.add("rootProvider");
            }
            if (this.threadPoolSizeBuildStage == -1) {
                attributes.add("threadPoolSize");
            }
            if (this.connectionProviderBuildStage == -1) {
                attributes.add("connectionProvider");
            }
            if (this.sslCertificateTrusterBuildStage == -1) {
                attributes.add("sslCertificateTruster");
            }
            if (this.threadPoolBuildStage == -1) {
                attributes.add("threadPool");
            }
            return "Cannot build DefaultConnectionContext, attribute initializers form cycle " + attributes;
        }
    }
}

