/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SigningKeyResolver;
import java.util.Optional;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.uaa.UaaSigningKeyResolver;
import org.cloudfoundry.uaa.tokens.Tokens;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

final class UsernameProvider {
    private final ConnectionContext connectionContext;
    private final SigningKeyResolver signingKeyResolver;
    private final TokenProvider tokenProvider;

    UsernameProvider(ConnectionContext connectionContext, TokenProvider tokenProvider, Tokens tokens) {
        this(connectionContext, new UaaSigningKeyResolver(tokens), tokenProvider);
    }

    UsernameProvider(ConnectionContext connectionContext, SigningKeyResolver signingKeyResolver, TokenProvider tokenProvider) {
        this.connectionContext = connectionContext;
        this.tokenProvider = tokenProvider;
        this.signingKeyResolver = signingKeyResolver;
    }

    Mono<String> get() {
        return UsernameProvider.getToken(this.connectionContext, this.tokenProvider).map(this::getUsername).subscribeOn(Schedulers.elastic()).retry(1L, t -> {
            if (t instanceof ExpiredJwtException) {
                this.tokenProvider.invalidate(this.connectionContext);
                return true;
            }
            return false;
        });
    }

    private static Mono<String> getToken(ConnectionContext connectionContext, TokenProvider tokenProvider) {
        return Mono.defer(() -> tokenProvider.getToken(connectionContext)).map(s -> s.split(" ")[1]);
    }

    private String getUsername(String token) {
        Jws jws = Jwts.parser().setSigningKeyResolver(this.signingKeyResolver).parseClaimsJws(token);
        return (String)Optional.ofNullable(((Claims)jws.getBody()).get("user_name", String.class)).orElseThrow(() -> new IllegalStateException("Unable to retrieve username from token"));
    }
}

