/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v3;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.client.v3.FilterParameter;
import org.cloudfoundry.reactor.util.AnnotationUtils;
import org.cloudfoundry.reactor.util.UriQueryParameter;
import org.cloudfoundry.reactor.util.UriQueryParameterBuilder;

final class FilterBuilder
implements UriQueryParameterBuilder {
    FilterBuilder() {
    }

    @Override
    public Stream<UriQueryParameter> build(Object instance) {
        return AnnotationUtils.streamAnnotatedValues(instance, FilterParameter.class).map(FilterBuilder::processValue).filter(Objects::nonNull);
    }

    private static UriQueryParameter processCollection(String name, Object value) {
        return FilterBuilder.processValue(name, ((Collection)value).stream().map(Object::toString).map(String::trim).collect(Collectors.toList()));
    }

    private static UriQueryParameter processValue(AnnotationUtils.AnnotatedValue<FilterParameter> annotatedValue) {
        FilterParameter filterParameter = annotatedValue.getAnnotation();
        Object value = annotatedValue.getValue();
        if (value instanceof Collection) {
            return FilterBuilder.processCollection(filterParameter.value(), value);
        }
        return FilterBuilder.processValue(filterParameter.value(), value.toString());
    }

    private static UriQueryParameter processValue(String name, Collection<String> collection) {
        String value = String.join((CharSequence)",", collection);
        if (!value.isEmpty()) {
            return FilterBuilder.processValue(name, value);
        }
        return null;
    }

    private static UriQueryParameter processValue(String name, String value) {
        return UriQueryParameter.of(name, value);
    }
}

