/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.logcache.v1;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.QueryBuilder;
import org.cloudfoundry.reactor.util.AbstractReactorOperations;
import org.cloudfoundry.reactor.util.UriQueryParameter;
import org.cloudfoundry.reactor.util.UriQueryParameters;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class AbstractLogCacheOperations
extends AbstractReactorOperations {
    protected AbstractLogCacheOperations(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider, Map<String, String> requestTags) {
        super(connectionContext, root, tokenProvider, requestTags);
    }

    protected final <T> Mono<T> get(Object requestPayload, Class<T> responseType, String ... pathSegments) {
        return this.createOperator().flatMap(operator -> operator.get().uri(this.buildPathSegments(pathSegments).andThen(this.queryTransformer(requestPayload))).response().parseBody(responseType));
    }

    private Function<UriComponentsBuilder, UriComponentsBuilder> buildPathSegments(String[] pathSegments) {
        return builder -> builder.pathSegment(new String[]{"api", "v1"}).pathSegment(pathSegments);
    }

    private Function<UriComponentsBuilder, UriComponentsBuilder> queryTransformer(Object requestPayload) {
        return builder -> {
            Stream<UriQueryParameter> parameters = new QueryBuilder().build(requestPayload);
            UriQueryParameters.set(builder, parameters);
            return builder;
        };
    }
}

