/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.cloudfoundry.reactor.AbstractRootProvider;
import org.cloudfoundry.reactor.ConnectionContext;
import org.immutables.value.Value;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Value.Immutable
abstract class _InfoPayloadRootProvider
extends AbstractRootProvider {
    _InfoPayloadRootProvider() {
    }

    @Override
    protected Mono<UriComponents> doGetRoot(ConnectionContext connectionContext) {
        return Mono.just((Object)this.getRoot());
    }

    @Override
    protected Mono<UriComponents> doGetRoot(String key, ConnectionContext connectionContext) {
        return this.getInfo(connectionContext).map(info -> {
            if (!info.containsKey(key)) {
                throw new IllegalArgumentException(String.format("Info payload does not contain key '%s'", key));
            }
            return this.normalize(UriComponentsBuilder.fromUriString((String)((String)info.get(key))));
        });
    }

    abstract ObjectMapper getObjectMapper();

    private UriComponentsBuilder buildInfoUri(UriComponentsBuilder root) {
        return root.pathSegment(new String[]{"v2", "info"});
    }

    @Value.Derived
    private Mono<Map<String, String>> getInfo(ConnectionContext connectionContext) {
        return this.createOperator(connectionContext).flatMap(operator -> operator.get().uri(this::buildInfoUri).response().parseBody(Map.class)).map(payload -> payload).switchIfEmpty(Mono.error((Throwable)new IllegalArgumentException("Info endpoint does not contain a payload"))).checkpoint();
    }
}

